; TASM defines for PMC v0.8b by Tran (a.k.a Thomas Pytel).

; Segment defines

_TEXT           segment dword public use32 'CODE'
_TEXT           ends
_DATA           segment dword public use32 'DATA'
_DATA           ends
_BSS            segment dword public use32 'BSS'
_BSS            ends

DGROUP          group   _DATA, _BSS
assume  cs:_TEXT, ds:DGROUP

_TEXTseg        macro
_TEXT           segment dword public use32 'CODE'
assume  cs:_TEXT, ds:DGROUP
endm

_DATAseg        equ _DATA segment dword public use32 'DATA'
_BSSseg         equ _BSS segment dword public use32 'BSS'


; Basic types

NULL            = 0
FALSE           = 0
TRUE            = 1


; General macros

rlp             macro reg,p
        mov &reg,&p
        sub &reg,_database
endm

lnp             macro reg,p
        mov &reg,&p
        add &reg,_database
endm

dcp             macro reg,p
        mov &reg,&p
        add &reg,_code_data
endm

cdp             macro reg,p
        mov &reg,&p
        add &reg,_data_code
endm


; Memory and addresses

SEGOFF          struc
sgoff           dw      ?
sgseg           dw      ?
ends

SELOFF          struc
sloff           dd      ?
slsel           dw      ?
ends

MEMBLOCK        struc
mbbase          dd      ?
mbsize          dd      ?
mbhandle        dd      ?
ends


; Selectors and descriptors

DESCRIPTOR      struc
dsclimit_l      dw      ?
dscbase_l       dw      ?
dscbase_m       db      ?
dscaccess       dw      ?
dscbase_h       db      ?
ends


; Register data structure

REGSTRUCT       struc
rsEDI           label   dword
rsDI            dw      ?,?
rsESI           label   dword
rsSI            dw      ?,?
rsEBP           label   dword
rsBP            dw      ?,?
rsRESERVED      dd      ?
rsEBX           label   dword
rsBX            label   word
rsBL            db      ?
rsBH            db      ?,?,?
rsEDX           label   dword
rsDX            label   word
rsDL            db      ?
rsDH            db      ?,?,?
rsECX           label   dword
rsCX            label   word
rsCL            db      ?
rsCH            db      ?,?,?
rsEAX           label   dword
rsAX            label   word
rsAL            db      ?
rsAH            db      ?,?,?
rsFLAGS         dw      ?
rsES            dw      ?
rsDS            dw      ?
rsFS            dw      ?
rsGS            dw      ?
rsCSIP          label   dword
rsIP            dw      ?
rsCS            dw      ?
rsSSSP          label   dword
rsSP            dw      ?
rsSS            dw      ?
enDS

fCF             = 0001h
fPF             = 0004h
fAF             = 0010h
fZF             = 0040h
fSF             = 0080h
fTF             = 0100h
fIF             = 0200h
fDF             = 0400h
fOF             = 0800h


; System variables, directly accessible in real mode in _DATA

extrn   __PMpagetables  : byte
extrn   __PMselectors   : word
extrn   __PMrmstacklen  : word
extrn   __PMpmstacklen  : word
extrn   __PMrmstacks    : byte
extrn   __PMpmstacks    : byte
extrn   __PMcallbacks   : byte
extrn   __pmcrmstacklen : word
extrn   __pmcrmstacks   : byte
extrn   __rmcpmstacklen : word
extrn   __rmcpmstacks   : byte

extrn   __stklen        : dword
extrn   __lowheaplen    : dword
extrn   __extheapmin    : dword
extrn   __extheapmax    : dword
extrn   __minosversion  : word
extrn   __lowbufptr     : dword
extrn   __lowbuflen     : word

extrn   _codebase       : dword
extrn   _database       : dword
extrn   _pspbase        : dword
extrn   _envbase        : dword
extrn   _codesel        : word
extrn   _datasel        : word
extrn   _pspsel         : word
extrn   _envsel         : word
extrn   __TEXTseg       : word
extrn   __DATAseg       : word
extrn   __BSSseg        : word
extrn   _zeroptr        : dword
extrn   _data_code      : dword
extrn   _code_data      : dword

extrn   _osversion      : word
extrn   _osminor        : byte
extrn   _osmajor        : byte
extrn   _DPMIversion    : word
extrn   _DPMIminor      : byte
extrn   _DPMImajor      : byte

extrn   _CPL            : byte
extrn   _selinc         : word
extrn   _PMtype         : byte
extrn   _processor      : byte
extrn   _PICtable       : byte
extrn   _PICmaster      : byte
extrn   _PICslave       : byte

extrn   _rmstate        : dword
extrn   _rmswitch       : dword
extrn   _pmstate        : fword
extrn   _pmswitch       : fword
extrn   _statesize      : word

extrn   _pmcrmnoregs    : dword
extrn   _pmcrmregs      : dword
extrn   _pmcrminoregs   : dword
extrn   _pmcrmiregs     : dword
extrn   _rmcpmnoregs    : dword
extrn   _rmcpmregs      : dword
extrn   _rmcpminoregs   : dword
extrn   _rmcpmiregs     : dword

extrn   _pmstacklen     : dword
extrn   _pmstackbase    : dword
extrn   _pmstacktop     : dword
extrn   _rmstacklen     : word
extrn   _rmstackbase    : word
extrn   _rmstacktop     : word

extrn   _lowheapblock   : dword
extrn   _extheapblock   : dword
extrn   _rs             : dword

; Possibly above first 64k of _DATA, not accessible directly in real mode


; DPMI function error codes

_DPMI09ERROR            = -32768

_DPMIUNSUPPORTED        = -32767
_DPMIBADSTATE           = -32766
_DPMISYSINTEGRITY       = -32765
_DPMIDEADLOCK           = -32764
_DPMICANCELLED          = -32763

_DPMINORESOURCE         = -32752
_DPMINODESCRIPTOR       = -32751
_DPMINOLINEARMEM        = -32750
_DPMINOPHYSICALMEM      = -32749
_DPMINOBACKINGSTORE     = -32748
_DPMINOCALLBACK         = -32747
_DPMINOHANDLE           = -32746

_DPMILOCKEXCEEDED       = -32745
_DPMIRESOURCEEXCLUSIVE  = -32744
_DPMIRESOURCESHARED     = -32743

_DPMIBADVALUE           = -32735
_DPMIBADSELECTOR        = -32734
_DPMIBADHANDLE          = -32733
_DPMIBADCALLBACK        = -32732
_DPMIBADLINEARADDRESS   = -32731
_DPMIBADREQUEST         = -32730

; DOS function error codes

_DOSBADFUNCTION         = -65535
_DOSBADFILE             = -65534
_DOSBADPATH             = -65533
_DOSNOHANDLES           = -65532
_DOSACCESSDENIED        = -65531
_DOSBADHANDLE           = -65530
_DOSBADACCESSCODE       = -65524
_DOSBADDRIVE            = -65521
_DOSCURRENTDIR          = -65520
_DOSNOTSAMEDEVICE       = -65519
_DOSNOMOREFILES         = -65518

; File open mode codes

RDONLY                  = 0
WRONLY                  = 1
RDWR                    = 2

; File seek from codes

SEEK_SET                = 0
SEEK_CUR                = 1
SEEK_END                = 2

; File find attributes and mode

FA_NORMAL               = 000h
FA_RDONLY               = 001h
FA_HIDDEN               = 002h
FA_SYSTEM               = 004h
FA_LABEL                = 008h
FA_DIREC                = 010h
FA_ARCH                 = 020h

FF_FIRST                = 04eh
FF_NEXT                 = 04fh

; IRQ mask values

IRQENABLED              = 0
IRQDISABLED             = 1

; Code stub types

RMSTUBINRI              = 0
RMSTUBINRC              = 1
RMSTUBFNRI              = 2
RMSTUBFNRC              = 3
RMSTUBIRI               = 4
RMSTUBIRC               = 5
RMSTUBFRI               = 6
RMSTUBFRC               = 7

RMSTUBNRLEN             = 020h
RMSTUBRLEN              = 0c0h
PMSTUBLEN               = 044h

; IRQ types

IRQI                    = 0
IRQC                    = 1
IRQOWN                  = 2

IRQILEN                 = RMSTUBNRLEN
IRQCLEN                 = RMSTUBNRLEN + PMSTUBLEN
IRQOWNLEN               = 0

