//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1994, by Farley Carter
//   source\owl\validate.h
//----------------------------------------------------------------------------
#if !defined(__OWL_FLOATVAL_H)
#define __OWL_FLOATVAL_H

#if !defined(__OWL_VALIDATE_H)
  #include <owl\validate.h>
#endif

//
// class TFloatValidator
// ----- ---------------
//
class _OWLCLASS TFloatValidator : public TValidator {
  public:
	 TFloatValidator(int Length, int Decimals = 2,double min=0.0, double max = 0.0);
	 // override TValidator's virtuals
	 void	Error();
	 void SetRange(double min, double max);
	 BOOL CheckNumber(const char far* str);
	 BOOL IsValid(const char far* str);
	 BOOL IsValidInput(char far* str, BOOL suppressFill = TRUE);

  protected:
	 double  Min;
	 double  Max;
	 int		Length;
	 int		Decimals;
  DECLARE_STREAMABLE(_OWLCLASS, TFloatValidator, 1);
};

class _OWLCLASS TIntValidator : public TValidator {
  public:
	 TIntValidator(int Length, long min=0, long max = 0);
	 // override TValidator's virtuals
	 void	Error();
	 void SetRange(long min, long max);
	 BOOL CheckNumber(const char far* str);
	 BOOL IsValid(const char far* str);
	 BOOL IsValidInput(char far* str, BOOL suppressFill = TRUE);

  protected:
	 long  Min;
	 long  Max;
	 int		Length;
  DECLARE_STREAMABLE(_OWLCLASS, TIntValidator, 1);
};

class _OWLCLASS TDateValidator : public TValidator {
  public:
	 TDateValidator();
	 // override TValidator's virtuals
	 void	Error();
	 BOOL CheckDate(const char far* str);
	 BOOL IsValid(const char far* str);
	 BOOL IsValidInput(char far* str, BOOL suppressFill = TRUE);

  protected:
	 int month;
	 int day;
  DECLARE_STREAMABLE(_OWLCLASS, TDateValidator, 1);
};

#endif

