#include <stdio.h>

#include "dpmish.h"
#include "dosext.h"


int DosExtender::installIntHandler(
    int intNr,
    DpmiInterruptVector func,
    unsigned& handle)
{
    unsigned temp;
    asm {
        mov ax, EXAPI_INSTALL
        mov bx, intNr
        mov cx, word ptr func+2
        mov dx, word ptr func
        int _EXTENDER_VECT
        mov temp, bx
    }
    handle = temp;
    return _AX;
}


void DosExtender::removeIntHandler( unsigned handle )
{
    asm {
        mov ax, EXAPI_REMOVE
        mov bx, handle
        int _EXTENDER_VECT
    }
}

void DosExtender::initComm(int port, int baud, int flags)
{
    asm {
        mov ax, EXAPI_INITCOMM
        mov bx, port
        mov cx, baud
        mov dx, flags
        int _EXTENDER_VECT
    }
}

void DosExtender::termComm(int port)
{
    asm {
        mov ax, EXAPI_TERMCOMM
        mov bx, port
        int _EXTENDER_VECT
    }
}

void DosExtender::readComm(int port, CommRequest far *req)
{
    asm {
        mov ax, EXAPI_READCOMM
        mov bx, port
        mov cx, word ptr req+2
        mov dx, word ptr req
        int _EXTENDER_VECT
    }
}


void DosExtender::writeComm(int port , CommRequest far *req)
{
    asm {
        mov ax, EXAPI_WRITECOMM
        mov bx, port
        mov cx, word ptr req+2
        mov dx, word ptr req
        int _EXTENDER_VECT
    }
}


