/* PLHELP.C : Command handler for HELP command.
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "piclab.h"

static char *helpmain[] = {
	"PICLAB is a public domain product that may be distibuted freely and used",
	"without restrictions of any kind.  No contributions are required, but",
	"any cash, software, or images you feel like sending will be put to use.",
	" ",
	"For further information on this and other Stone Soup Group products,",
	"contact the author at one of the following addresses:",
	" ",
	"Lee Daniel Crocker     CompuServe: 73407,2030",
	"1380 Jewett Ave               BIX: lcrocker",
	"Pittsburg, CA  94565       Usenet: ...!ames!pacbell!sactoh0!siva!lee",
	" ",
	"########################## ### ## # # # #  # #  #",
	"########## #### ## # # # ##  # # ## ## # ## # ##  ## ## # # # # #",
	"######## #### ### ##### # ##### # # # # #        #       #        #  #",
	"############ ## ### # ## ## #  # # # # # ###### #  # # ##   #  #",
	"###### ########### ### ### # ## ### # # #      #  #   #    #  #    #     #",
	"########## #### # ## ### #### ##   # # # ### #   #  #    #   #   #",
	" ",
	"Typing LIST COMMANDS will give you a list of valid commands.  You can get",
	"help on one of these commands by typing HELP <command name>.  For example,",
	"type HELP GLOAD to get help on the GLOAD command.",
	NULL };

static int ktype;
static char *ktypes[] = { "Command", "File format", "Display type",
	"Printer type", "Variable" };

/* HELP command handler
*/

U16 *find_keyword(char *word)
{
	int i;
	static U16 junk;

	for (i=0; cmdtable[i].command; ++i) {
		if (strcmp(word, cmdtable[i].command) == 0) {
			ktype = 0;
			return &cmdtable[i].fileoff;
		}
	}
	for (i=0; formats[i].name; ++i) {
		if (strcmp(word, formats[i].name) == 0) {
			ktype = 1;
			return &formats[i].fileoff;
		}
	}
	for (i=0; displays[i].name; ++i) {
		if (strcmp(word, displays[i].name) == 0) {
			ktype = 2;
			return &displays[i].fileoff;
		}
	}
	for (i=0; printers[i].name; ++i) {
		if (strcmp(word, printers[i].name) == 0) {
			ktype = 3;
			return &printers[i].fileoff;
		}
	}
	for (i=0; vartable[i].varname; ++i) {
		if (strcmp(word, vartable[i].varname) == 0) {
			ktype = 4;
			return &vartable[i].fileoff;
		}
	}
	junk = 0;
	return &junk;
}

static void load_help(void)
{
	char keyword[40], *kp;
	U8 *buf;
	int h, c, state;
	U32 mem;
	U16 ofs = 0, *lp;

	mem = mark();
	if ((buf = talloc(BUFSIZE+80)) == NULL) return;
	if ((h = p_open(helpfile, buf, BUFSIZE, 80, READ)) < 0) return;

	state = 0;
	kp = keyword;

	pl_printf(reading, "help file");
	while (1) {
		if ((c = p_getc(h)) == -1) break;

		switch (state) {
			case 0:
				if (c == '~') state = 1;
				break;
			case 1:
				if (!isspace(c = toupper(c))) *kp++ = (char)c;
				else {
					*kp = '\0';
					kp = keyword;
					lp = find_keyword(keyword);
					state = 2;
				}
				break;
			case 2:
				if (isspace(c)) break;
				else state = 3;	/* fall through */
			case 3:
				*lp = ofs;
				state = 0;
				break;
			default:
				break;
		}
		++ofs;
	}
	p_close(h);
	release(mem);
	helploaded = 1;
}

int help(int ac, argument *av)
{
	U8 *buf;
	char lbuf[80];
	U32 mem;
	int c, i, h, bw;
	U16 fileoff;

	if (ac <= 1) for (i=0; helpmain[i]; ++i) pl_printf("%s\r\n", helpmain[i]);
	else {
		if (!helploaded) load_help();
		fileoff = *find_keyword(av[1].cval);

		if (fileoff != 0L) {
			pl_printf("\r\n%s (%s):\r\n\r\n", av[1].cval, ktypes[ktype]);

			mem = mark();
			if ((buf = talloc(BUFSIZE+80)) == NULL) return 2;
			if ((h = p_open(helpfile, buf, BUFSIZE, 80, READ)) < 0) return 3;
			p_seek(h, (long)fileoff);

			i = 0;
			while (1) {
				if ((c = p_getc(h)) == -1 || c == '~') break;
				if (i == sizeof(lbuf)) {
					_dos_write(1, lbuf, i, &bw);
					i = 0;
				}
				lbuf[i++] = (char)c;
			}
			if (i > 0) _dos_write(1, lbuf, i, &bw);

			p_close(h);
			release(mem);
		} else pl_printf("Sorry, no help is available on that subject.\r\n");
	}
	return 0;
}
