/* PLSHOW.C : Screen display routines for PICLAB.  Command handler for
** SHOW is here.  Requires external routines from VIDEO.ASM.
*/

#include <stdlib.h>
#include <dos.h>
#include <memory.h>
#include <string.h>
#include <conio.h>

#include "piclab.h"
#include "sierra"
#include "yiq"

/* VGA DAC register values for 256-level pseudo-grayscale.	All values
** are 0..63 in red, green, blue order.
**
** Values in gamma2[] are used for displaying images encoded at a
** gamma near 2.0, and gamma1[] is used for displaying images encoded
** at near 1.0.
**
** Tables created by Lee Daniel Crocker on 6/2/89 based on an idea by
** Mark Peterson and Mike Vigneau.	This is public domain.
*/

static U8 gamma1[256][3] = {
  {  0,  0,  0 }, {  5,  3,  5 }, {  6,  5,  7 }, {  6,  7,  8 },
  {  8,  8,  7 }, {  8,  9, 10 }, { 11,  9,  9 }, {  9, 11, 11 },
  { 11, 11, 12 }, { 11, 12, 13 }, { 12, 13, 11 }, { 13, 13, 14 },
  { 15, 13, 13 }, { 13, 15, 13 }, { 16, 14, 15 }, { 16, 15, 15 },
  { 16, 16, 14 }, { 16, 16, 18 }, { 18, 16, 17 }, { 18, 17, 16 },
  { 19, 17, 17 }, { 18, 18, 19 }, { 18, 19, 17 }, { 19, 19, 18 },
  { 18, 20, 19 }, { 21, 19, 20 }, { 20, 20, 21 }, { 20, 21, 19 },
  { 21, 21, 20 }, { 21, 21, 23 }, { 23, 21, 21 }, { 22, 22, 22 },
  { 21, 23, 22 }, { 22, 23, 23 }, { 23, 23, 23 }, { 22, 24, 23 },
  { 23, 24, 24 }, { 24, 24, 24 }, { 23, 25, 24 }, { 26, 24, 24 },
  { 25, 25, 25 }, { 25, 25, 27 }, { 25, 26, 25 }, { 26, 26, 25 },
  { 27, 26, 25 }, { 26, 27, 25 }, { 27, 27, 25 }, { 27, 27, 28 },
  { 28, 27, 27 }, { 29, 27, 27 }, { 28, 28, 27 }, { 27, 29, 27 },
  { 28, 29, 27 }, { 30, 28, 29 }, { 29, 29, 29 }, { 29, 29, 31 },
  { 30, 29, 31 }, { 30, 30, 28 }, { 30, 30, 30 }, { 31, 30, 30 },
  { 31, 30, 32 }, { 30, 31, 32 }, { 31, 31, 32 }, { 32, 31, 31 },
  { 32, 31, 33 }, { 31, 32, 33 }, { 32, 32, 32 }, { 31, 33, 32 },
  { 33, 32, 34 }, { 33, 33, 31 }, { 33, 33, 33 }, { 33, 33, 35 },
  { 33, 34, 32 }, { 33, 34, 34 }, { 34, 34, 33 }, { 33, 35, 33 },
  { 33, 35, 35 }, { 36, 34, 34 }, { 36, 34, 36 }, { 35, 35, 36 },
  { 34, 36, 35 }, { 36, 35, 37 }, { 37, 35, 36 }, { 36, 36, 35 },
  { 35, 37, 35 }, { 35, 37, 37 }, { 36, 37, 36 }, { 37, 37, 35 },
  { 37, 37, 37 }, { 37, 37, 39 }, { 38, 37, 38 }, { 39, 37, 37 },
  { 39, 37, 39 }, { 38, 38, 38 }, { 38, 38, 40 }, { 38, 39, 37 },
  { 40, 38, 38 }, { 40, 38, 40 }, { 39, 39, 39 }, { 39, 39, 41 },
  { 39, 40, 38 }, { 41, 39, 39 }, { 41, 39, 41 }, { 40, 40, 40 },
  { 40, 40, 42 }, { 41, 40, 41 }, { 42, 40, 40 }, { 40, 41, 42 },
  { 41, 41, 41 }, { 42, 41, 40 }, { 40, 42, 42 }, { 41, 42, 41 },
  { 42, 42, 40 }, { 42, 42, 41 }, { 42, 42, 43 }, { 43, 42, 42 },
  { 42, 43, 41 }, { 42, 43, 43 }, { 44, 42, 44 }, { 43, 43, 43 },
  { 43, 43, 45 }, { 42, 44, 44 }, { 43, 44, 43 }, { 44, 44, 42 },
  { 44, 44, 43 }, { 44, 44, 45 }, { 43, 45, 44 }, { 44, 45, 43 },
  { 46, 44, 44 }, { 44, 45, 46 }, { 45, 45, 45 }, { 44, 46, 44 },
  { 46, 45, 45 }, { 45, 46, 44 }, { 45, 46, 46 }, { 47, 45, 47 },
  { 46, 46, 46 }, { 45, 47, 45 }, { 47, 46, 46 }, { 47, 46, 48 },
  { 46, 47, 47 }, { 48, 46, 48 }, { 47, 47, 47 }, { 46, 48, 46 },
  { 48, 47, 47 }, { 48, 47, 49 }, { 47, 48, 48 }, { 49, 47, 49 },
  { 48, 48, 48 }, { 47, 49, 47 }, { 49, 48, 48 }, { 48, 49, 47 },
  { 50, 48, 48 }, { 48, 49, 50 }, { 49, 49, 49 }, { 49, 49, 50 },
  { 48, 50, 49 }, { 50, 49, 50 }, { 49, 50, 49 }, { 51, 49, 50 },
  { 50, 50, 49 }, { 50, 50, 51 }, { 50, 50, 52 }, { 49, 51, 51 },
  { 51, 50, 52 }, { 50, 51, 51 }, { 52, 50, 52 }, { 51, 51, 51 },
  { 51, 51, 52 }, { 50, 52, 51 }, { 52, 51, 52 }, { 51, 52, 51 },
  { 53, 51, 52 }, { 52, 52, 51 }, { 52, 52, 52 }, { 53, 52, 51 },
  { 53, 52, 52 }, { 52, 53, 51 }, { 54, 52, 52 }, { 53, 53, 51 },
  { 53, 53, 52 }, { 53, 53, 54 }, { 53, 53, 55 }, { 52, 54, 54 },
  { 54, 53, 55 }, { 53, 54, 54 }, { 53, 54, 55 }, { 54, 54, 54 },
  { 54, 54, 55 }, { 54, 54, 56 }, { 53, 55, 55 }, { 55, 54, 56 },
  { 54, 55, 55 }, { 54, 55, 56 }, { 55, 55, 55 }, { 55, 55, 56 },
  { 55, 55, 57 }, { 54, 56, 56 }, { 56, 55, 57 }, { 55, 56, 56 },
  { 56, 56, 54 }, { 56, 56, 55 }, { 56, 56, 57 }, { 56, 56, 58 },
  { 57, 56, 56 }, { 56, 57, 55 }, { 58, 56, 56 }, { 57, 57, 55 },
  { 57, 57, 56 }, { 57, 57, 57 }, { 56, 58, 56 }, { 58, 57, 57 },
  { 58, 57, 58 }, { 57, 58, 57 }, { 59, 57, 58 }, { 59, 57, 59 },
  { 58, 58, 58 }, { 58, 58, 59 }, { 58, 58, 60 }, { 57, 59, 59 },
  { 59, 58, 60 }, { 60, 58, 58 }, { 59, 59, 57 }, { 59, 59, 58 },
  { 59, 59, 59 }, { 58, 60, 58 }, { 60, 59, 59 }, { 60, 59, 60 },
  { 59, 60, 59 }, { 59, 60, 60 }, { 61, 59, 61 }, { 60, 60, 60 },
  { 60, 60, 61 }, { 60, 60, 62 }, { 61, 60, 60 }, { 60, 61, 59 },
  { 62, 60, 60 }, { 62, 60, 61 }, { 61, 61, 60 }, { 61, 61, 61 },
  { 61, 61, 62 }, { 61, 61, 63 }, { 60, 62, 62 }, { 61, 62, 60 },
  { 63, 61, 61 }, { 62, 62, 60 }, { 62, 62, 61 }, { 62, 62, 62 },
  { 62, 62, 63 }, { 61, 63, 62 }, { 61, 63, 63 }, { 62, 63, 61 },
  { 62, 63, 62 }, { 63, 63, 61 }, { 63, 63, 62 }, { 63, 63, 63 } } ;

static U8 epal[] = { 000, 044, 022, 066, 011, 055, 033, 077 };

static union REGS regs;
static char unimp[] = "This display mode is not supported in version %s.\n";
static int xmax, ymax;

extern int setmode(int, int), getkey(void), keypressed(void);
extern void readdac(U8 *), writedac(U8 *);
extern void xlat(U8 *, U8 *, U8 *, int), xlatp(U8 *, U8 *, U8 *, int);

int showpic(int ac, argument *av)
{
	U32 mem, mem2;
	struct _plane *ip[3];
	int k, d, i, l, r, p, np, mode, ctype, sline;
	int xoff, yoff, xsize, ysize, ylimit, lines;
	U8 *dp, *cp[3], *sp, *tp, *olddac, *newdac;

	r = 0;
	mem = mark();
	regs.x.ax = 0x0F00; 		/* Get current video mode for	*/
	int86(0x10, &regs, &regs);	/* later restoration.			*/
	mode = regs.h.al;

	switch (ac) {
		case 1: xoff = xorigin; 		yoff = yorigin; 		break;
		case 2: xoff = (int)av[1].fval; yoff = yorigin; 		break;
		default: pl_warn(1);
		case 3: xoff = (int)av[1].fval; yoff = (int)av[2].fval; break;
	}
	d = -1;
	l = strlen(display);
	for (i=0; displays[i].name != NULL; ++i) {
		if (strncmp(display, displays[i].name, l) == 0) {
			d = i; break;
		}
	}

	if (d == -1) return 9;
	else {
		if ((r = setmode(displays[d].pax, displays[d].pbx)) != 0) {
			r = 2; goto abort;
		}
		xmax = displays[d].width;
		ymax = displays[d].height;
	}
	if ((ctype = displays[d].ctype) == 1) sp = (U8 *)talloc(3 * xmax);
	else sp = (U8 *)talloc(xmax);
	if (sp == NULL) return 2;
	if ((tp = (U8 *)talloc(xmax)) == NULL) return 2;

#pragma loop_opt(off)

	if (ctype == 1) {
		for (i=0; i<8; ++i) {
			regs.x.ax = 0x1000;
			regs.h.bl = (U8)(i + 8);
			regs.h.bh = epal[i];
			int86(0x10, &regs, &regs);
		}
		outpw(0x3CE, 0xFF08);
		outpw(0x3CE, 0x05);
		outpw(0x3CE, 0x03);
		outpw(0x3CE, 0x01);
	} else if (ctype == 2) {
		if ((olddac = (U8 *)talloc(768)) == NULL) return 2;
		readdac(olddac);
		if (new->flags & 2) {
			mem2 = mark();
			if ((dp = newdac = (U8 *)talloc(768)) == NULL) return 2;

			if (transpend) {
				for (i=0; i<256; ++i) {
					*dp++ = (lookup[0][gcmap[0][i]] >> 2);
					*dp++ = (lookup[1][gcmap[1][i]] >> 2);
					*dp++ = (lookup[2][gcmap[2][i]] >> 2);
				}
			} else for (i=0; i<256; ++i) {
				*dp++ = gcmap[0][i] >> 2;
				*dp++ = gcmap[1][i] >> 2;
				*dp++ = gcmap[2][i] >> 2;
			}
			writedac((U8 *)newdac);
			release(mem2);
		} else writedac((U8 *)gamma1);
	}

	np = new->planes;
	for (p=0; p<np; ++p) if ((ip[p] = openplane(p, new, READ)) == NULL) {
		r = 3; goto abort;
	}
	while (1) {
		if ((xsize = new->width - xoff) <= 0) { r = 9; goto abort; }
		if ((ysize = new->height - yoff) <= 0) { r = 9; goto abort; }
		if (xsize > xmax) xsize = xmax;
		if (ysize > ymax) ysize = ymax;
		ylimit = yoff + ysize;

		if (new->flags & 1) sline = ymax-1; else sline = 0;
		for (p=0; p<np; ++p) seekline(ip[p], yoff);

		for (lines = yoff; lines < ylimit; ++lines) {
			if (ctype == 1) memset(sp, 0, 3 * xmax); else memset(sp, 0, xmax);
			for (p=0; p<np; ++p) if (getline(ip[p]) == 0) { r = 4; goto abort; }
			if (new->flags & 2) {		/* color mapped */
				dp = ip[0]->linebuf + xoff;
				if (ctype == 0) {
					if (transpend) {
						xlat(dp, tp, gcmap[0], xsize);
						xlat(tp, tp, lookup[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(dp, tp, gcmap[1], xsize);
						xlat(tp, tp, lookup[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(dp, tp, gcmap[2], xsize);
						xlat(tp, tp, lookup[2], xsize);
						xlatp(tp, sp, by, xsize);
					} else {
						xlat(dp, tp, gcmap[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(dp, tp, gcmap[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(dp, tp, gcmap[2], xsize);
						xlatp(tp, sp, by, xsize);
					}
				} else if (ctype == 1) {
					if (transpend) {
						xlat(dp, sp, gcmap[0], xsize);
						xlat(sp, sp, lookup[0], xsize);
						xlat(dp, sp+xmax, gcmap[1], xsize);
						xlat(sp+xmax, sp+xmax, lookup[1], xsize);
						xlat(dp, sp+2*xmax, gcmap[2], xsize);
						xlat(sp+2*xmax, sp+2*xmax, lookup[2], xsize);
					} else {
						xlat(dp, sp, gcmap[0], xsize);
						xlat(dp, sp+xmax, gcmap[1], xsize);
						xlat(dp, sp+2*xmax, gcmap[2], xsize);
					}
				} else memcpy(sp, dp, xsize);

			} else if (np == 1) {		/* grayscale	*/
				dp = ip[0]->linebuf + xoff;
				if (transpend) xlat(dp, sp, lookup[0], xsize);
				else memcpy(sp, dp, xsize);

				if (ctype == 1) {
					memcpy(sp+xmax, sp, xsize);
					memcpy(sp+2*xmax, sp, xsize);
				}

			} else {					/* true color	*/
				for (i=0; i<3; ++i) cp[i] = ip[i]->linebuf + xoff;
				if (ctype == 1) {
					if (transpend) {
						xlat(cp[0], sp, lookup[0], xsize);
						xlat(cp[1], sp+xmax, lookup[1], xsize);
						xlat(cp[2], sp+2*xmax, lookup[2], xsize);
					} else {
						memcpy(sp, cp[0], xsize);
						memcpy(sp+xmax, cp[1], xsize);
						memcpy(sp+2*xmax, cp[2], xsize);
					}
				} else {
					if (transpend) {
						xlat(cp[0], tp, lookup[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(cp[1], tp, lookup[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(cp[2], tp, lookup[2], xsize);
						xlatp(tp, sp, by, xsize);
					} else {
						xlat(cp[0], sp, ry, xsize);
						xlatp(cp[1], sp, gy, xsize);
						xlatp(cp[2], sp, by, xsize);
					}
				}
			}

#pragma loop_opt(on)

			(*displays[d].linefunc)(sline, sp);
			if (keypressed()) break;
			if (new->flags & 1) --sline; else ++sline;
		}
		memset(sp, 0, xmax);
		for (lines = ylimit; lines < (yoff+ymax); ++lines) {
			(*displays[d].linefunc)(sline, sp);
			if (new->flags & 1) --sline; else ++sline;
		}
		if ((k = getkey()) == -72) {		/* Up */
			yoff -= (ymax >> 2);
			if (yoff < 0) yoff = 0;
		} else if (k == -75) {				/* Left */
			xoff -= (xmax >> 2);
			if (xoff < 0) xoff = 0;
		} else if (k == -77) {				/* Right */
			xoff += (xmax >> 2);
			if (xoff > new->width-1)
			  xoff = new->width-1;
		} else if (k == -80) {				/* Down */
			yoff += (ymax >> 2);
			if (yoff > new->height-1)
			  yoff = new->height-1;
		} else break;
	}
abort:
	for (p=0; p<np; ++p) closeplane(ip[p]);

	if (ctype == 1) {
		outpw(0x3C4, 0xF02);
		outpw(0x3CE, 0xFF08);
		outpw(0x3C4, 0x03);
		outpw(0x3C4, 0x01);
	} else if (ctype == 2) {
		writedac(olddac);
	}
	release(mem);
	setmode(mode, 0);
	return r;
}

#if 0

static U8 masks[] = { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };
static U8 bayer[8][8] = {
	{  2,130, 34,162, 10,138, 42,170},
	{194, 66,226, 98,202, 74,234,106},
	{ 50,178, 18,146, 58,186, 26,154},
	{242,114,210, 82,250,122,218, 90},
	{ 14,142, 46,174,  6,134, 38,166},
	{206, 78,238,110,198, 70,230,102},
	{ 62,190, 30,158, 54,182, 22,150},
	{254,126,222, 94,246,118,214, 86} };

#define setbit(x,p) (p)[(x)>>3]|=masks[(x)&7]

void cgaline(int sline, U8 *gray)
{
	register U8 *bp, *lp;
	U8 *sp, bitmap[80];
	U32 address;
	int x;

	memset(bitmap, 0, 80);
	bp = bitmap;
	lp = bayer[sline&7];
	for (x=0; x < 640; ++x) if (gray[x>>1] > lp[x&7]) setbit(x,bp);
	if (sline & 1) address = 0xBA000000; else address = 0xB8000000;
	address += 80 * (sline >> 1);
	memcpy((char *)address, bitmap, 80);
}

void egaline(int sline, U8 *indices)
{
	register U8 *bp, *lp;
	U8 *sp[3], bitmap[3][80];
	U32 address;
	int i, x;

	lp = bayer[sline&7];
	for (i=0; i<3; ++i) {
		memset(bitmap[i], 0, 80);
		sp[i] = indices + i * xmax;
		bp = bitmap[i];
		for (x=0; x < 640; ++x) if (sp[i][x] > lp[x&7]) setbit(x,bp);
	}
	address = 0xA0000000 + 80 * sline;

	outpw(0x3C4, 0x102);
	memcpy((char *)address, bitmap[0], 80);
	outpw(0x3C4, 0x202);
	memcpy((char *)address, bitmap[1], 80);
	outpw(0x3C4, 0x402);
	memcpy((char *)address, bitmap[2], 80);
	outpw(0x3C4, 0x802);
	memset((char *)address, 0xFF, 80);
}

#endif
