/* MEMORY.C : The previous description of this module, below, is accurate
** except where it describes 'permanent' allocations.  This feature was
** removed because PICLAB does not need it, but I may put it back later.
*/
/* MEMORY.C : Memory allocation functions.	Two types of allocation requests
** are handled here--permanent and mark/release.  Permanent allocations are
** blocks of memory that remain allocated throughout the life of the program.
** Mark/release blocks are usually used within a function, and released when
** that function exits.  Memory is requested from the OS all at once at the
** start of the program.  Permanent allocations are taken from the top of this
** large block and mark/release allocations are take from the bottom.  These
** functions are _very_ dependent upon MSDOS, and will not work in any other
** environment.  It should not be very difficult to create equivalent routines
** for other environments, especially linear-adress machines like the 68000
** and 80386.  Command handler for SHELL (alias DOS, CALL) is here also.
*/

#include <stdlib.h>
#include <string.h>
#ifdef MSDOS
  #include <process.h>
  #include <dos.h>
#endif

#include "piclab.h"

#ifdef MSDOS
static char huge *bigblock;
static unsigned long dtop, size;
static unsigned segment, paragraphs;
static union REGS r;
static int initialized = 0;

static void initmem(void);

static void initmem()
{
    initialized = 1;                /* Grab all the RAM we can find now and */
    r.h.ah = 0x48;                  /* parcel it out later.                 */
    r.x.bx = 0xFFFF;
    if (int86(0x21, &r, &r) == 8) {
        paragraphs = r.x.bx - 1;
		if (_dos_allocmem(paragraphs, &segment)) {
			pl_printf("Memory allocation error.\n");
			size = 0L;
			return;
		}

        FP_SEG(bigblock) = segment;
        FP_OFF(bigblock) = 0;
        size = (U32)paragraphs << 4;
        dtop = 0L;
	} else {
		pl_printf("Memory allocation error.\n");
		size = 0L;
	}
	return;
}

char FAR *talloc(U16 bytes) 		/* This function returns NULL if memory */
{									/* is not available.					*/
	char FAR *cfp;
	U32 absolute;

    if (!initialized) initmem();
    if ((long)bytes > size-dtop) return NULL;
	cfp = (char FAR *)(&bigblock[dtop]);
    dtop += bytes;
	if (dtop & 1) ++dtop;	/* Stay on word boundary */

	/* Must put pointer in canonical form */
	absolute = ((U32)FP_SEG(cfp) << 4) + FP_OFF(cfp);
	FP_SEG(cfp) = (U16)(absolute >> 4);
	FP_OFF(cfp) = (U16)(absolute & 0x0F);
    return cfp;
}

U32 mark() { if (!initialized) initmem(); return dtop; }
void release(U32 m) { if (!initialized) initmem(); dtop = m; }
U32 freemem() { if (!initialized) initmem(); return size-dtop; }

void releaseall()
{
    unsigned max;

    if (!initialized) initmem();
    if (_dos_setblock(paragraphs, segment, &max)) {
        paragraphs = max;
        size = (U32)paragraphs << 4;
        _dos_setblock(paragraphs, segment, &max);
    }
    dtop = 0L;
}
#else
  char FAR *talloc(U16 bytes) {}
  U32 mark() {}
  void release(U32 m) {}
  U32 freemem() {}
  void releaseall() {}
#endif

/* Command handler for SHELL, DOS, and CALL commands.  If command was CALL,
** run the named program passing it the remainder of the command line as
** arguments.  Otherwise shell out to COMMAND.COM.
*/
int shell(int ac, argument *av)
{
    int i, rv;
    char *comspec, *args[10];
    unsigned np, max;

    if (!initialized) initmem();

	if (*av[0].cval == 'C') {
		np = (unsigned)((dtop+minalloc) >> 4);
		if (_dos_setblock(np, segment, &max)) return 2;

		for (i=1; i<ac; ++i) args[i-1] = av[i].cval;
        args[ac-1] = NULL;
        rv = spawnvp(P_WAIT, args[0], args);
    } else {
		np = (unsigned)(dtop >> 4) + 1;
		if (_dos_setblock(np, segment, &max)) return 2;

		if ((comspec = getenv("COMSPEC")) == NULL) {
			pl_printf("Cannot find COMMAND.COM.\n");
			return 0;
		}
        if (ac == 1) {
            putenv("PROMPT=Type 'EXIT' to return to PICLAB.$_$p$g");
            rv = spawnl(P_WAIT, comspec, NULL);
        } else {
            args[0] = comspec;
            args[1] = "/C";
            for (i=1; i<ac; ++i) args[i+1] = av[i].cval;
            args[ac+1] = NULL;
			rv = spawnv(P_WAIT, args[0], args);
        }
    }

    if (!initialized) initmem();
    if (_dos_setblock(paragraphs, segment, &max)) {
        paragraphs = max;
        size = (U32)paragraphs << 4;
        _dos_setblock(paragraphs, segment, &max);
    }
	if (rv < 0) {
		pl_printf("Error in spawn() call: %d.\n", errno);
	} else if (rv > 0) {
		pl_printf("Subprocess returned error: %d.\n", rv);
	}
	return 0;
}
