; VIDEO.ASM
;
; Miscellaneous assembly routines for video I/O in Piclab.  This code is
; copyrighted (C) 1988,89,90 by Lee Daniel Crocker and John Bridges, but
; is freely distributable.  Most of the Super VGA code is John's and was
; generously donated to the developers of the CompuServe PICS forum.  I
; have made some changes to his original code, so any screw-ups are
; probably mine.
;
; John can be reached at CompuServe [73307,606] or through GRAFX group:
;
; GRAFX Group
; 30448 Rancho Viejo, Suite 100
; San Juan Capistrano, CA  92675
;

extrn	_palette:word
extrn	_gcmap:byte

V_TEXT	segment word public 'CODE'
V_TEXT	ends
_DATA	segment word public 'DATA'
_DATA	ends
CONST	segment word public 'CONST'
CONST	ends
_BSS	segment word public 'BSS'
_BSS	ends

DGROUP	group	CONST, _BSS, _DATA
	assume	cs:V_TEXT, ds:_DATA, ss:DGROUP

	public	_chipset

_DATA	segment

curbk	dw	0
bankadr	dw	offset V_TEXT:$nobank
_chipset dw	0
vgatype	dw	0

result	dw	0
rsave	dw	0
gsave	dw	0
bsave	dw	0
dist	dd	0
ldist	dd	0

ax1	dw	6f05h, 6f05h, 0,   5eh, 78h, 5ch, 61h, 70h, 60h, 60h
bx1	dw	66h,   66h,   0,   0,   0,   0,   0,   14h, 0,   0

ax2	dw	6f05h, 6f05h, 2eh, 5fh, 79h, 5dh, 62h, 70h, 61h, 61h
bx2	dw	67h,   67h,   0,   0,   0,   0,   0,   30h, 0,   0

ax3	dw	6f05h, 6f05h, 30h, 0,   7bh, 5eh, 63h, 70h, 62h, 62h
bx3	dw	69h,   69h,   0,   0,   0,   0,   0,   31h, 0,   0

vptbl	dw	06b00h	; horz total
	dw	05901h	; horz displayed
	dw	05a02h	; start horz blanking
	dw	08e03h	; end horz blanking
	dw	05e04h	; start h sync
	dw	08a05h	; end h sync
	dw	00d06h	; vertical total
	dw	03e07h	; overflow
	dw	04009h	; cell height
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	02d13h	; offset
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode
vpend	label	word

bayer2	db	2, 130, 34, 162, 10, 138, 42, 170
	db	194, 66, 226, 98, 202, 74, 234, 106
	db	50, 178, 18, 146, 58, 186, 26, 154
	db	242, 114, 210, 82, 250, 122, 218, 90
	db	14, 142, 46, 174, 6, 134, 38, 166
	db	206, 78, 238, 110, 198, 70, 230, 102
	db	62, 190, 30, 158, 54, 182, 22, 150
	db	254, 126, 222, 94, 246, 118, 214, 86

_DATA	ends

V_TEXT	segment

$cirrus	proc	near
	sub	di, di
	mov	dx, 3d4h	; assume 3dx addressing
	mov	al, 0ch		; screen a start address hi
	out	dx, al		; select index
	inc	dx		; point to data
	mov	ah, al		; save index in ah
	in	al, dx		; get screen a start address hi
	xchg	ah, al		; swap index and data
	push	ax		; save old value
	push	dx		; save crtc address
	xor	al, al		; clear crc
	out	dx, al		; and out to the crtc

	mov	al, 1fh		; Eagle ID register
	dec	dx		; back to index
	out	dx, al		; select index
	inc	dx		; point to data
	in	al, dx		; read the id register
	mov	bh, al		; and save it in bh

	mov	cl, 4		; nibble swap rotate count
	mov	dx, 3c4h	; sequencer/extensions
	mov	bl, 6		; extensions enable register

	ror	bh, cl		; compute extensions disable value
	mov	ax, bx		; extensions disable
	out	dx, ax		; disable extensions
	inc	dx		; point to data
	in	al, dx		; read enable flag
	or	al, al		; disabled ?
	jnz	exit		; nope, not an cirrus

	ror	bh, cl		; compute extensions enable value
	dec	dx		; point to index
	mov	ax, bx		; extensions enable
	out	dx, ax		; enable extensions
	inc	dx		; point to data
	in	al, dx		; read enable flag
	cmp	al, 1		; enabled ?
	jne	exit		; nope, not a cirrus
	mov	di, 1
exit:
	pop	dx		; restore crtc address
	dec	dx		; point to index
	pop	ax		; recover crtc index and data
	out	dx,ax		; restore crtc value
	ret
$cirrus	endp

$gochk	proc	near
	push	si
	mov	si, bx

	mov	al, cl
	call	dx
	xchg	bl, es:[di]
	mov	al, ch
	call	dx
	xchg	bh, es:[di]

	xchg	si, bx

	mov	al, cl
	call	dx
	xor	bl, es:[di]
	mov	al, ch
	call	dx
	xor	bh, es:[di]

	xchg	si, bx

	mov	al, ch
	call	dx
	mov	es:[di], bh
	mov	al, cl
	call	dx
	mov	es:[di], bl

	mov	al, 0
	call	dx
	or	si, si
	pop	si
	ret
$gochk	endp

$chkbk	proc	near		;paradise bank switch check
	mov	di, 0b800h
	mov	es, di
	xor	di, di
	mov	bx, 1234h
	call	$gochk
	jnz	nopara
	mov	bx, 4321h
	call	$gochk
	jnz	nopara
	clc
	ret
nopara:
	stc
	ret
$chkbk	endp

$pdrsub	proc	near		;Paradise
	push	dx
	mov	ah, al
	mov	dx, 3ceh
	mov	al, 9
	out	dx, ax
	pop	dx
	ret
$pdrsub	endp

$tseng	proc	near		;Tseng
	push	ax
	push	dx
	and	al, 7
	mov	ah, al
	shl	ah, 1
	shl	ah, 1
	shl	ah, 1
	or	al, ah
	or	al, 01000000b
	mov	dx, 3cdh
	out	dx, al
	pop	dx
	pop	ax
	ret
$tseng	endp

$trident proc	near		;Trident
	push	ax
	push	dx
	mov	dx, 3ceh	;set page size to 64k
	mov	al, 6
	out	dx, al
	inc	dl
	in	al, dx
	dec	dl
	or	al, 4
	mov	ah, al
	mov	al, 6
	out	dx, ax
		
	mov	dl, 0c4h	;switch to BPS mode
	mov	al, 0bh
	out	dx, al
	inc	dl
	in	al, dx
	dec	dl

	mov	ah, byte ptr [curbk]
	xor	ah, 2
	mov	dx, 3c4h
	mov	al, 0eh
	out	dx, ax
	pop	dx
	pop	ax
	ret
$trident endp

$video7 proc	near		;Video 7
	push	ax
	push	dx
	push	cx
	and	ax, 15
	mov	ch, al
	mov	dx, 3c4h
	mov	ax, 0ea06h
	out	dx, ax
	mov	ah, ch
	and	ah, 1
	mov	al, 0f9h
	out	dx, ax
	mov	al, ch
	and	al, 1100b
	mov	ah, al
	shr	ah, 1
	shr	ah, 1
	or	ah, al
	mov	al, 0f6h
	out	dx, al
	inc	dx
	in	al, dx
	dec	dx
	and	al, not 1111b
	or	ah, al
	mov	al, 0f6h
	out	dx, ax
	mov	ah, ch
	mov	cl, 4
	shl	ah, cl
	and	ah, 100000b
	mov	dl, 0cch
	in	al, dx
	mov	dl, 0c2h
	and	al, not 100000b
	or	al, ah
	out	dx, al
	pop	cx
	pop	dx
	pop	ax
	ret
$video7 endp
	
$paradise proc	near		;Paradise
	push	ax
	push	dx
	mov	dx, 3ceh
	mov	ax, 50fh	;turn off write protect on VGA registers
	out	dx, ax
	mov	ah, byte ptr [curbk]
	shl	ah, 1
	shl	ah, 1
	shl	ah, 1
	shl	ah, 1
	mov	al, 9
	out	dx, ax
	pop	dx
	pop	ax
	ret
$paradise endp

$chipstech proc	near		;Chips & Tech
	push	ax
	push	dx
	mov     dx, 46e8h	;place chip in setup mode
	mov     ax, 1eh
	out     dx, ax
	mov     dx, 103h	;enable extended registers
	mov     ax, 0080h
	out     dx, ax
	mov     dx, 46e8h	;bring chip out of setup mode
	mov     ax, 0eh
	out     dx, ax
	mov	ah, byte ptr [curbk]
	shl	ah, 1		;change 64k bank number into 16k bank number
	shl	ah, 1
	mov	al, 10h
	mov	dx, 3d6h
	out	dx, ax
	pop	dx
	pop	ax
	ret
$chipstech endp

$ativga proc	near		;ATI VGA Wonder
	push	ax
	push	dx
	mov	ah, al
	mov	dx, 1ceh
	mov	al, 0b2h
	out	dx, al
	inc	dl
	in	al, dx
	shl	ah, 1
	and	al, 0e1h
	or	ah, al
	mov	al, 0b2h
	dec	dl
	out	dx, ax
	pop	dx
	pop	ax
	ret
$ativga endp

$everex proc	near		;Everex
	push	ax
	push	dx
	push	cx
	mov	cl, al
	mov	dx, 3c4h
	mov	al, 8
	out	dx, al
	inc	dl
	in	al, dx
	dec	dl
	shl	al, 1
	shr	cl, 1
	rcr	al, 1
	mov	ah, al
	mov	al, 8
	out	dx, ax
	mov	dl, 0cch
	in	al, dx
	mov	dl, 0c2h
	and	al, 0dfh
	shr	cl, 1
	jc	nob2
	or	al, 20h
nob2:	out	dx, al
	pop	cx
	pop	dx
	pop	ax
	ret
$everex endp

$aheada	proc	near
	push	ax
	push	dx
	push	cx
	mov	ch, al
        mov     dx, 3ceh	;Enable extended registers
        mov     ax, 200fh
        out     dx, ax
	mov	dl, 0cch	;bit 0
	in	al, dx
	mov	dl, 0c2h
	and	al, 11011111b
	shr	ch, 1
	jnc	@f
	or	al, 00100000b
@@:	out	dx, al
	mov	dl, 0cfh	;bits 1,2,3
	mov	al, 0
	out	dx, al
	inc	dx
	in	al, dx
	dec	dx
	and	al, 11111000b
	or	al, ch
	mov	ah, al
	mov	al, 0
	out	dx, ax
	pop	cx
	pop	dx
	pop	ax
	ret
$aheada	endp

$aheadb	proc	near
	push	ax
	push	dx
	push	cx
	mov	ch, al
        mov     dx, 3ceh	;Enable extended registers
        mov     ax, 200fh
        out     dx, ax
	mov	ah, ch
	mov	cl, 4
	shl	ah, cl
	or	ah, ch
	mov	al, 0dh
	out	dx, ax
	pop	cx
	pop	dx
	pop	ax
	ret
$aheadb	endp

WinGran	dw	0
WinFP	dd	0

$vesa	proc	near
	push	ax
	push	bx
	push	cx
	push	dx
	mul	cs:[WinGran]
	mov	dx, ax
	mov	ax, 4f05h
	sub	bx, bx
	call	cs:[WinFP]
	sti
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
$vesa	endp

$nobank	proc	near
	ret
$nobank	endp

;
;	int vtype(void)
;
; Returns one of the following codes according to the video adapter found:
;
;  -1	MDA, Herc, or other unsupported adapter
;   0	CGA or 64k EGA
;   1	EGA
;   2	Standard VGA
;   3	256k SuperVGA
;   4	512k SuperVGA
;
; If 3 or 4 is returned, the variable "chipset" is set to one of these:
;
;   1	Cirrus
;   2	Headland (Video 7, New Dell)
;   3	Tseng Labs (Orchid, Genoa, Willow)
;   4	Paradise (Old Compaq, Dell)
;   5	Chips & Technologies
;   6	Trident
;   7	ATI VGA Wonder
;   8	Everex EVGA or Viewpoint
;   9	Ahead Systems "A"
;  10	Ahead Systems "B"
;  11	VESA
;

public	_vtype
_vtype	proc	far

	push	bp
	mov	bp, sp
	sub	sp, 256			; VESA info buffer

	push	si
	push	ds
	push	di

	mov	ax, _DATA
	mov	ds, ax

	sub	bx, bx
	mov	ax, 1A00h
	int	10h
	cmp	al, 1Ah
	je	couldbe
	jmp	notvga
couldbe:
	cmp	bl, 7
	jae	isvga
	jmp	notvga
isvga:
	mov	si, 3
	mov	ax, 0C000h
	mov	es, ax
	cmp	word ptr es:[40h], '13'
	jnz	noati
	mov	[_chipset], 7
	mov	[bankadr], offset V_TEXT:$ativga

	cli
	mov	dx, 1ceh
	mov	al, 0bbh
	out	dx, al
	inc	dl
	in	al, dx
	sti
	and	al, 20h
	jz	no512
	inc	si
no512:
	jmp	fini
noati:
	mov	ax, 7000h		;Test for Everex
	xor	bx, bx
	cld
	int	10h
	cmp	al, 70h
	jnz	noev
	mov	[_chipset], 8
	mov	[bankadr], offset V_TEXT:$everex

	and	ch, 11000000b
	jz	@f
	inc	si
@@:	and	dx, 0fff0h
	cmp	dx, 6780h
	jz	yeste
	cmp	dx, 2360h
	jnz	note
yeste:
	mov	[_chipset], 6
	mov	[bankadr],offset V_TEXT:$trident
note:
	jmp	fini
noev:
	mov	dx, 3c4h		;Test for Trident
	mov	al, 0bh
	out	dx, al
	inc	dl
	in	al, dx
	cmp	al, 0fh
	ja	notri
	cmp	al, 2
	jb	notri

	mov	[_chipset], 6
	mov	[bankadr], offset V_TEXT:$trident
	inc	si
	jmp	fini
notri:
	mov	ax, 6f00h		;Test for Video 7
	xor	bx, bx
	cld
	int	10h
	cmp	bx, 'V7'
	jnz	nov7
	mov	[_chipset], 2
	mov	[bankadr], offset V_TEXT:$video7

	mov	ax, 6f07h
	cld
	int	10h
	and	ah, 7fh
	cmp	ah, 1
	jbe	@f
	inc	si
@@:	jmp	fini
nov7:
	call	$cirrus			;Test for Cirrus
	cmp	[_chipset], 0
	je	noci
	jmp	fini
noci:
	mov	dx, 3ceh		;Test for Paradise
	mov	al, 9			;check Bank switch register
	out	dx, al
	inc	dx
	in	al, dx
	dec	dx
	or	al, al
	jnz	nopara2

	mov	ax, 50fh		;turn off write protect on VGA registers
	out	dx, ax
	mov	dx, offset V_TEXT:$pdrsub
	mov	cx, 1
	call	$chkbk
	jc	nopara2			;if bank 0 and 1 same not paradise
	mov	[_chipset], 4
	mov	[bankadr], offset V_TEXT:$paradise

;	mov	cx, 64
;	call	$chkbk
;	jc	@f			;if bank 0 and 64 same only 256k
	inc	si
@@:	jmp	fini
nopara2:
	mov	ax, 5f00h		;Test for Chips & Tech
	xor	bx, bx
	cld
	int	10h
	cmp	al, 5fh
	jnz	noct
	mov	[_chipset], 5
	mov	[bankadr], offset V_TEXT:$chipstech

	cmp	bh, 1
	jb	fini
	inc	si
	jmp	short fini
noct:
	mov	dx, 3cdh		;Test for Tseng
	in	al, dx
	and	al, 00111111b		;check bank switch register
	jnz	nots

	mov	[_chipset], 3
	mov	[bankadr], offset V_TEXT:$tseng
	inc	si
	jmp	short fini
nots:
        mov     dx, 3ceh		;Test for Ahead A or B chipsets
        mov     ax, 200fh
        out     dx, ax
        inc	dx
        in      al, dx
	cmp	al, 21h
	jz	verb
	cmp	al, 20h
	jnz	noab
	mov	[_chipset], 9
	mov	[bankadr], offset V_TEXT:$aheada
	inc	si
	jmp	short fini
verb:
	mov	[_chipset], 10
	mov	[bankadr], offset V_TEXT:$aheadb
	inc	si
	jmp	short fini
noab:
	push	ss			; Test for VESA
	pop	es
	lea	di, [bp-256]
	mov	ax, 4F00h
	int	10h
	cmp	ax, 034Fh
	jne	nosvga

	mov	ax, word ptr [bp-256]
	cmp	ax, 4556h		; 'VE'
	jne	nosvga
	mov	ax, word ptr [bp-254]
	cmp	ax, 4153h		; 'SA'
	jne	nosvga

	mov	[_chipset], 11
	mov	[bankadr], offset V_TEXT:$vesa
	inc	si
	jmp	short fini
nosvga:
	mov	ax, 2
	jmp	short vtout
fini:
	mov	ax, si
	jmp	short vtout
notvga:
	mov	ah, 12h
	mov	bl, 10h
	int	10h
	cmp	bl, 10h
	je	notega
	cmp	bl, 0
	jne	not64k
	sub	ax, ax
	jmp	short vtout
not64k:
	mov	ax, 1
	jmp	short vtout
notega:
	int	11h
	and	al, 30h
	cmp	al, 30h
	jne	cgaok
	mov	ax, -1
	jmp	short vtout
cgaok:
	sub	ax, ax
vtout:
	pop	di
	pop	ds
	pop	si

	mov	sp, bp
	pop	bp
	ret

_vtype	endp

;
;	newbank()
;

newbank	proc	near		;bank number is in AX
	push	ds

	push	ax
	mov	ax, _DATA
	mov	ds, ax
	pop	ax

	cli
	cmp	ax, [curbk]
	je	samebk
	mov	[curbk], ax
	call	word ptr [bankadr]
samebk:
	sti
	pop	ds
	ret
newbank	endp

nextbank proc	near
	push	ds

	push	ax
	mov	ax, _DATA
	mov	ds, ax
	pop	ax

	cli
	mov	ax, [curbk]
	inc	ax
	mov	[curbk], ax
	call	word ptr [bankadr]

	sti
	pop	ds
	ret
nextbank endp

setvesa	proc	near
	push	bp
	mov	bp, sp
	sub	sp, 256

	int	10h
	cmp	ah, 0
	jne	svfail

	mov	cx, bx
	push	ss
	pop	es
	lea	di, [bp-256]
	mov	ax, 4F01h
	int	10h
	cmp	ah, 0
	jne	svfail

	mov	cs:[WinGran], ax
	mov	word ptr cs:[WinFP], ax
	mov	ax, [bp-242]
	mov	word ptr cs:[WinFP+2], ax
svfok:
	sub	ax, ax
	jmp	short svret
svfail:
	mov	ax, -1
svret:
	mov	sp, bp
	pop	bp
	ret
setvesa	endp

;
;	int setmode(int ax, int bx);
;
public	_setmode
_setmode proc	far 

pax	equ	word ptr [bp+6]
pbx	equ	word ptr [bp+8]

	push	bp
	mov	bp, sp
	sub	sp, 256

	push	ds
	push	si
	push	di

	mov	ax, _DATA
	mov	ds, ax
	mov	ax, -1
	mov	[curbk], ax

	mov	ax, pax
	mov	bx, pbx

	cmp	ax, 0
	je	tweak
	cmp	ax, 4F01h
	jne	setbios
	call	setvesa
	jmp	smout
setbios:
	push	bp
	int	10h
	pop	bp
	jmp	svreturn

tweaktype dw	0

tweak:
	cmp	bx, 8
	jne	nott8
sv360x480:
	mov	ax, 13h
	int	10h

	mov	dx, 3c4h
	mov	ax, 604h
	out	dx, ax

	mov	ax, 0f02h
	out	dx, ax

	mov	ax, 0a000h
	mov	es, ax
	sub	di, di
	mov	ax, di
	mov	cx, 21600
	rep	stosw

	mov	ax, 100h
	out	dx, ax
	mov	dx, 3c2h
	mov	al, 0e7h
	out	dx, al
	mov	dx, 3c4h
	mov	ax, 300h
	out	dx, ax

	mov	dx, 3d4h
	mov	al, 11h
	out	dx, al
	inc	dx
	in	al, dx
	and	al, 7fh
	out	dx, al
	dec	dx

	mov	ax, _DATA
	mov	ds, ax
	mov	si, offset _DATA:vptbl
	mov	cx, ((offset _DATA:vpend)-(offset _DATA:vptbl)) / 2
svl1:
	lodsw
	out	dx, ax
	loop	svl1
	jmp	short svreturn
nott8:
	cmp	bx, 10
	jne	nott10

	jmp	badmode		; Tweak 10 not currently supported
nott10:
	mov	si, [_chipset]
	dec	si
	shl	si, 1

	cmp	bx, 1
	jne	nott1
	mov	ax, ax1[si]
	mov	bx, bx1[si]
	jmp	short svgaset
nott1:
	cmp	bx, 2
	jne	nott2
	mov	ax, ax2[si]
	mov	bx, bx2[si]
	jmp	short svgaset
nott2:
	cmp	bx, 3
	jne	nott3
	mov	ax, ax3[si]
	mov	bx, bx3[si]
svgaset:
	cmp	ax, 0
	jne	setok
	cmp	bx, 0
	je	badmode
setok:
	jmp	setbios
nott3:
badmode:
	mov	ax, -1
	jmp	short smout
svreturn:
	sub	ax, ax
smout:
	pop	di
	pop	si
	pop	ds

	mov	sp, bp
	pop	bp
	ret

_setmode endp

;
;	int keypressed(void);
;

public	_keypressed
_keypressed proc far

	mov	ah, 1
	int	16h
	jnz	gotit
	sub	ax, ax
	jmp	short kpout
gotit:
	mov	ax, 1
kpout:
	ret

_keypressed endp

;
;	int getkey(void);
;

public	_getkey
_getkey proc	far

	mov	ah, 0
	int	16h
	cmp	al, 0
	je	special
	sub	ah, ah
	jmp	short keyout
special:
	mov	al, ah
	sub	ah, ah
	neg	ax
keyout:
	ret

_getkey endp

;
;	void vga1line(int line, U8 *indices);
;

public	_vga1line
_vga1line proc	far

line	equ	word ptr [bp+6]
indices equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	push	ds
	push	si
	push	es
	push	di

	mov	ax, 0a000h
	mov	es, ax
	mov	ax, line
	mov	cx, 320
	mul	cx
	mov	di, ax
	lds	si, indices
	rep	movsb

	pop	di
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret

_vga1line endp

;
;	void vga2line(int line, U8 *indices);
;

public	_vga2line
_vga2line proc	far

line	equ	word ptr [bp+6]
indices equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	push	ds
	push	si
	push	es
	push	di

	lds	si, indices
	les	di, indices
	mov	cx, 40
	mov	bx, si
v2l1:
	lodsw
	stosb
	lodsw
	stosb
	lodsw
	stosb
	lodsw
	stosb
	movsb
	lodsw
	stosb
	lodsw
	stosb
	lodsw
	stosb
	movsb

	loop	v2l1
	mov	si, bx

	mov	cx, 90
v2l2:
	lodsb
	mov	byte ptr es:[di], al
	lodsb
	mov	byte ptr es:[di+90], al
	lodsb
	mov	byte ptr es:[di+180], al
	lodsb
	mov	byte ptr es:[di+270], al
	inc	di
	loop	v2l2

	mov	si, bx
	add	si, 360
	mov	ax, 0a000h
	mov	es, ax
	mov	ax, 90
	mul	line
	mov	bx, ax
	mov	dx, 3c4h

	mov	di, bx
	mov	cx, 45
	mov	ax, 0102h
	out	dx, ax
	rep	movsw

	mov	di, bx
	mov	cx, 45
	mov	ax, 0202h
	out	dx, ax
	rep	movsw

	mov	di, bx
	mov	cx, 45
	mov	ax, 0402h
	out	dx, ax
	rep	movsw

	mov	di, bx
	mov	cx, 45
	mov	ax, 0802h
	out	dx, ax
	rep	movsw

	pop	di
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret

_vga2line endp

;
;	void svga640line(int line, U8 *indices);
;

public	_svga640line
_svga640line proc	far

line	equ	word ptr [bp+6]
indices equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	push	ds
	push	si
	push	es
	push	di

	mov	ax, 0a000h
	mov	es, ax
	lds	si, indices

	mov	ax, line
	mov	cx, 640
	mul	cx

	mov	di, ax
	mov	ax, dx
	call	newbank

	mov	cx, 640
	cmp	di, 64897	; 65536 - 639
	jbe	onebank1

	mov	cx, di
	push	cx
	neg	cx
	rep	movsb

	pop	cx
	add	cx, 640
	call	nextbank
onebank1:
	rep	movsb

	pop	di
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret

_svga640line endp

;
;	void svga800line(int line, U8 *indices);
;

public	_svga800line
_svga800line proc	far

line	equ	word ptr [bp+6]
indices equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	push	ds
	push	si
	push	es
	push	di

	mov	ax, 0a000h
	mov	es, ax
	lds	si, indices

	mov	ax, line
	mov	cx, 800
	mul	cx

	mov	di, ax
	mov	ax, dx
	call	newbank

	mov	cx, 800
	cmp	di, 64737	; 65536 - 799
	jbe	onebank2

	mov	cx, di
	push	cx
	neg	cx
	rep	movsb

	pop	cx
	add	cx, 800
	call	nextbank
onebank2:
	rep	movsb

	pop	di
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret

_svga800line endp

;
;	void cgaline(int line, U8 *gray);
;

public	_cgaline
_cgaline proc	 far

line	equ	word ptr [bp+6]
gray	equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	sub	sp, 80	; bitmap = [bp-80]

	push	ds
	push	si
	push	es
	push	di

	lea	di, [bp-80]
	push	ss
	pop	es
	mov	cx, 40
	sub	ax, ax
	rep	stosw
	lea	bx, [bp-80]

	mov	dl, 80h
	lds	si, gray
	mov	ax, _DATA
	mov	es, ax
	mov	di, offset _DATA:bayer2
	mov	ax, line
	and	ax, 7
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	add	di, ax
	mov	cx, 80
cltop:
	mov	al, byte ptr ds:[si]
	cmp	al, byte ptr es:[di]
	jbe	nodot1
	or	byte ptr ss:[bx], dl
nodot1:
	inc	di
	shr	dl, 1

	lodsb
	cmp	al, byte ptr es:[di]
	jbe	nodot2
	or	byte ptr ss:[bx], dl
nodot2:
	inc	di
	shr	dl, 1
	jnc	cltop

	sub	di, 8
	mov	dl, 80h
	inc	bx
	loop	cltop

	mov	dx, 0B800h
	mov	ax, line
	shr	ax, 1
	jnc	notodd
	add	dx, 200h
notodd:
	mov	es, dx
	mov	cx, 80
	mul	cx
	mov	di, ax

	lea	si, [bp-80]
	push	ss
	pop	ds
	mov	cx, 40
	rep	movsw

	pop	di
	pop	es
	pop	si
	pop	ds

	mov	sp, bp
	pop	bp
	ret

_cgaline endp

;
;	void egaline(int line, U8 *indices);
;

public	_egaline
_egaline proc	 far

line	equ	word ptr [bp+6]
indices equ	dword ptr [bp+8]

	push	bp
	mov	bp, sp
	sub	sp, 240

	push	ds
	push	si
	push	es
	push	di

	lea	di, [bp-240]
	push	ss
	pop	es
	mov	cx, 120
	sub	ax, ax
	rep	stosw
	lea	bx, [bp-240]

	mov	dl, 80h
	lds	si, indices
	mov	ax, _DATA
	mov	es, ax
	mov	di, offset _DATA:bayer2
	mov	ax, line
	and	ax, 7
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	add	di, ax
	mov	cx, 80
eltop:
	mov	dh, byte ptr es:[di]
	lodsb
	cmp	al, dh
	jbe	nored
	or	byte ptr ss:[bx], dl
nored:
	mov	al, byte ptr ds:[si+639]
	cmp	al, dh
	jbe	nogreen
	or	byte ptr ss:[bx+80], dl
nogreen:
	mov	al, byte ptr ds:[si+1279]
	cmp	al, dh
	jbe	noblue
	or	byte ptr ss:[bx+160], dl
noblue:
	inc	di
	shr	dl, 1
	jnc	eltop

	sub	di, 8
	mov	dl, 80h
	inc	bx
	loop	eltop

	mov	dx, 0A000h
	mov	es, dx
	mov	ax, line
	mov	cx, 80
	mul	cx
	mov	bx, ax
	mov	di, bx

	push	ss
	pop	ds
	lea	si, [bp-240]

	mov	dx, 3C4h
	mov	ax, 0102h
	out	dx, ax

	mov	cx, 40
	rep	movsw

	mov	ax, 0202h
	out	dx, ax
	mov	di, bx
	mov	cx, 40
	rep	movsw

	mov	ax, 0402h
	out	dx, ax
	mov	di, bx
	mov	cx, 40
	rep	movsw

	mov	ax, 0802h
	out	dx, ax
	mov	ax, -1
	mov	di, bx
	mov	cx, 40
	rep	stosw

	pop	di
	pop	es
	pop	si
	pop	ds

	mov	sp, bp
	pop	bp
	ret

_egaline endp

;
;	void readdac(U8 *dac);
;

public	_readdac
_readdac proc	far

array	equ	dword ptr [bp+6]

	push	bp
	mov	bp, sp
	push	es

	les	dx, array
	mov	ax, 1017h
	mov	bx, 0
	mov	cx, 256
	int	10h

	pop	es
	pop	bp
	ret

_readdac endp

;
;	void writedac(U8 *dac);
;

public	_writedac
_writedac proc	far

array	equ	dword ptr [bp+6]

	push	bp
	mov	bp, sp
	push	es

	les	dx, array
	mov	ax, 1012h
	mov	bx, 0
	mov	cx, 256
	int	10h

	pop	es
	pop	bp
	ret

_writedac endp

;
;	void xlat(U8 *, U8 *, U8 *, int);
;

public	_xlat
_xlat	proc	far

source	equ	dword ptr [bp+6]
dest	equ	dword ptr [bp+10]
table	equ	dword ptr [bp+14]
count	equ	word ptr [bp+18]

	push	bp
	mov	bp, sp
	push	es
	push	di
	push	ds
	push	si

	lds	bx, table
	mov	dx, ds
	lds	si, source
	les	di, dest
	mov	cx, count
	mov	bp, ds
xtop:
	lodsb
	mov	ds, dx
	xlatb
	stosb
	mov	ds, bp
	loop	xtop

	pop	si
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret

_xlat	endp

;
;	void xlatp(U8 *, U8 *, U8 *, int);
;

public	_xlatp
_xlatp	proc	far

source	equ	dword ptr [bp+6]
dest	equ	dword ptr [bp+10]
table	equ	dword ptr [bp+14]
count	equ	word ptr [bp+18]

	push	bp
	mov	bp, sp
	push	es
	push	di
	push	ds
	push	si

	lds	bx, table
	mov	dx, ds
	lds	si, source
	les	di, dest
	mov	cx, count
	mov	bp, ds
xptop:
	lodsb
	mov	ds, dx
	xlatb
	add	byte ptr es:[di], al
	inc	di
	mov	ds, bp
	loop	xptop

	pop	si
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret

_xlatp	endp

;
;	void __nearest(U8 *, U8 *, int);
;
	assume	ds:DGROUP, es:_DATA

public	__nearest
__nearest proc far

input	equ	[bp+6]

	push	bp
	mov	bp, sp
	push	ds
	push	si
	push	es
	push	di

	lds	si, input
	mov	ax, _DATA
	mov	es, ax
	lodsw
	and	al, 0F8h
	add	al, 4
	mov	byte ptr es:rsave, al
	lodsw
	and	al, 0F8h
	add	al, 4
	mov	byte ptr es:gsave, al
	lodsw
	and	al, 0F8h
	add	al, 4
	mov	byte ptr es:bsave, al

	mov	ax, 0ffffh
	mov	word ptr es:ldist, ax
	mov	word ptr es:ldist+2, ax

	mov	ax, DGROUP
	mov	ds, ax
	mov	cx, _palette
	mov	si, offset DGROUP:_gcmap
nl1:
	sub	ah, ah
	lodsb
	sub	ax, es:rsave
	imul	ax

	mov	bx, ax
	mov	di, dx
	add	bx, ax
	adc	di, dx
	add	bx, ax
	adc	di, dx

	sub	ah, ah
	mov	al, byte ptr [si+255]
	sub	ax, es:gsave
	imul	ax
	shl	ax, 1
	rcl	dx, 1
	shl	ax, 1
	rcl	dx, 1
	add	bx, ax
	adc	di, dx

	sub	ah, ah
	mov	al, byte ptr [si+511]
	sub	ax, es:bsave
	imul	ax
	shl	ax, 1
	rcl	dx, 1
	add	bx, ax
	adc	di, dx

	mov	ax, word ptr es:ldist+2
	cmp	ax, di
	jb	skip
	ja	copy

	mov	ax, word ptr es:ldist
	cmp	ax, bx
	jbe	skip
copy:
	mov	word ptr es:ldist, bx
	mov	word ptr es:ldist+2, di
	mov	word ptr es:result, cx
skip:
	loop	nl1

	mov	ax, _palette
	sub	ax, word ptr es:result
bmdone:
	pop	di
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret
__nearest endp

V_TEXT	ends
	end
