/* PL2.C : Miscellaneous file format handlers for PICLAB.  Most are
** currently unimplemented, and will probably be moved to separate source
** files.  Command handlers include LOAD, SAVE, DIR, GDIR, TDIR.
*/

#include <stdlib.h>
#include <string.h>
#include <memory.h>

#ifdef MSDOS
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <io.h>
 #include <fcntl.h>
 #include <dos.h>
#endif

#include "piclab.h"

static int format(void);
static void tgafile(void);
static void giffile(void);
static void rixfile(void);
static void rawfile(void);
static void ipfile(void);

static char unimp[] 	= "Sorry, this file operation is not implemented.\n",
			*extens[]	= { "*", "TGA", "GIF", "VMG", "R8", "IP" },
			space[] 	= " ";

/* Utility routine to return the current file format as an integer.  If
** the current setting of the FORMAT variable is not recognized, this
** function returns -1.
*/
static int format()
{
	int i, l;

	l = strlen(fileformat);
	for (i=0; formats[i].name != NULL; ++i) {
		if (strncmp(fileformat, formats[i].name, l) == 0) {
			return i;
		}
	}
	return -1;
}

/* Procedure for LOAD command.	Pass all arguments to load handler for the
** current file format.
*/
int load(int ac, argument *av)
{
	int ff;

	if ((ff = format()) == -1) return 6;
	else return (*formats[ff].loadf)(ac, av);
}

/* Procedure for SAVE command.	Pass all arguments to save handler for the
** current file format.
*/
int save(int ac, argument *av)
{
	int ff;

	if ((ff = format()) == -1) return 6;
	else return (*formats[ff].savef)(ac, av);
}

#ifdef MSDOS

/* Below are the various directory commands.  This code is very kludged
** because it was taken from a GIF directory program I wrote some time ago.
** it has been adapted for the other formats and all of the variables which
** were global to the earlier program have been made static here.  There
** is certainly a better way to do this, but it was not a high priority.
*/

static char *crvals[] = { "8","64","512","4k","32k","256k","2M","16M" },
			spec[] = "*.XXX";

static struct find_t dta;
char fname[65];
U8 *bigbuf;
int i, l, h, co, cr, br;
U16 sw, sh;
char lc, *cp;

static void tgafile()
{
	char line[128];

	if (_dos_open(fname, O_RDONLY, &h) == 0) {
		*line = '\0';
		if (_dos_read(h, bigbuf, 1024, &br) == 0) {
			GET16(bigbuf[12],sw);
			GET16(bigbuf[14],sh);
			if (bigbuf[16] == 16) cr = 4; else cr = 7;
			strcpy(fname, dta.name);
			if ((cp = strchr(fname, '.')) != (char*)0) *cp = '\0';
			cp = space;
/*
			if ((l = bigbuf[0]) != 0) {
				cp = bigbuf + 18;
				cp[(l>47)?47:l] = '\0';
			}
*/
			if (bigbuf[16] == 8) {
				pl_sprintf(line, "%-8.8s%4ux%4ux 256/ 256%5ldk %s",
				  fname, sw, sh, (dta.size+512)>>10, cp);
			} else {
				pl_sprintf(line, "%-8.8s%4ux%4ux%4s/%4s%5ldk %s",
				  fname, sw, sh, crvals[cr], crvals[cr], (dta.size+512)>>10, cp);
			}
		}
		if (*line) pl_printf(line);
		_dos_close(h);
	}
}

static void giffile()
{
	char line[128];

	if (_dos_open(fname, O_RDONLY, &h) == 0) {
		*line = '\0';
		if (_dos_read(h, bigbuf, 1024, &br) == 0) {
			bigbuf[3] = '\0';
			if (strcmp(bigbuf, spec+2) == 0) {
				GET16(bigbuf[6],sw);
				GET16(bigbuf[8],sh);
				co = 1 << ((bigbuf[10]&7)+1);
				cr = (bigbuf[10]&0x70) >> 4;
				strcpy(fname, dta.name);
				if ((cp = strchr(fname, '.')) != (char*)0) *cp = '\0';
				if ((bigbuf[10]&0x80) == 0) cp = space;
				else {
					cp = bigbuf + 3 * co + 13;
					if (cp[0] == '!' && cp[1] == '\xFE') {
						cp[47] = '\0';
						if (cp[2] < 45) cp[3+cp[2]] = '\0';
						cp += 3;
					} else cp = space;

					cp = space; /* Disable comments */
				}
				pl_sprintf(line, "%-8.8s%4ux%4ux%4d/%4s%5ldk %s",
				  fname, sw, sh, co, crvals[cr], (dta.size+512)>>10, cp);
			}
		}
		if (*line) pl_printf(line);
		_dos_close(h);
	}
}

static void rixfile()
{
	strcpy(fname, dta.name);
	if ((cp = strchr(fname, '.')) != (char*)0) *cp = '\0';
	pl_printf("%s", fname);
}

static void rawfile()
{
	strcpy(fname, dta.name);
	if ((cp = strchr(fname, '.')) != (char*)0) *cp = '\0';
	pl_printf("%s", fname);
}

static void ipfile()
{
	strcpy(fname, dta.name);
	if ((cp = strchr(fname, '.')) != (char*)0) *cp = '\0';
	pl_printf("%s", fname);
}

static int dodir(int fmt, int ac, argument *av)
{
	char dname[65];
	int nfiles;

	if ((bigbuf = (U8 *)talloc(1024)) == NULL) return 2;
	if (fmt >= (sizeof(extens) / sizeof(extens[0]))) return 9;
	strcpy(spec+2, extens[fmt]);

	if (ac == 1) {
		strcpy(dname, picdir);
	} else {
		if (ac > 2) pl_warn(1);
		strcpy(dname, av[1].cval);
	}
	l = strlen(dname);
	if ((l==0) || (lc=dname[l-1]) == ':' || lc == '\\' || lc == '/') {
		strcpy(fname, dname);
		strcat(fname, spec);
		if (_dos_findfirst(fname, _A_NORMAL, &dta) != 0) return 10;
	} else {
		if (_dos_findfirst(dname, _A_NORMAL | _A_SUBDIR, &dta) == 0) {
			if (dta.attrib & _A_SUBDIR && *dta.name != '.') {
				strcat(dname, "/");
				strcpy(fname, dname);
				strcat(fname, spec);
				if (_dos_findfirst(fname, _A_NORMAL, &dta) != 0) return 10;
			} else {
				for (i=l-1; i>=0; --i) {
					if ((lc = dname[i]) == ':' || lc == '/' || lc == '\\') break;
					else dname[i] = '\0';
				}
			}
		}
	}
	nfiles = 0;
	do {
		strcpy(fname, dname);
		strcat(fname, dta.name);

		switch (fmt) {
			case 1: tgafile();	break;
			case 2: giffile();	break;
			case 3: rixfile();	break;
			case 4: rawfile();	break;
			case 5: ipfile();  break;
			case 0:
			default:
				pl_printf("%s\r\n", dta.name);
				break;
		}
		pl_printf((++nfiles & 1) ? "    " : crlf);
	} while (_dos_findnext(&dta) == 0);
	if (nfiles & 1) pl_printf(crlf);
	return 0;
}
#else
int dodir(int fmt, int ac, argument *av)
{
	pl_printf(unimp);
	return 0;
}
#endif

int filedir(int ac, argument *av)
{
	int ff;

	if ((ff = format()) == -1) return dodir(0, ac, av);
	else return dodir(ff+1, ac, av);
}

int gifdir(int ac, argument *av) { return dodir(2, ac, av); }
int tgadir(int ac, argument *av) { return dodir(1, ac, av); }

int loadrix(int ac, argument *av)
{
	int i, r, rfile;
	char *path;
	U8 *fbuf, *sp, *mp, *dp;
	U16 h, w, line;
	struct _plane *p;

	if (ac < 2) {
		pl_printf("Syntax is LOAD <filename>\r\n");
		return 0;
	} else {
		if (ac > 2) pl_warn(1);
		path = makepath(picdir, av[1].cval, "VMG");
	}

	if ((fbuf = (U8 *)talloc(BUFSIZE + 1024)) == NULL) return 2;
	if ((rfile = p_open(path, fbuf, BUFSIZE, 1024, READ)) < 0) return 10;
	pl_printf(reading, path);
	if ((r = begintransform()) != 0) return r;

	if (p_getline(rfile, 10) != 10) return 4;
	sp = linebuf(rfile);
	GET16(sp[4],w); 	if (w > 1024) return 7;
	GET16(sp[6],h);
	if (p_getline(rfile, 768) != 768) return 4;
	mp = linebuf(rfile);

	for (i=0; i<256; ++i) {
		gcmap[0][i] = *mp++ << 2;
		gcmap[1][i] = *mp++ << 2;
		gcmap[2][i] = *mp++ << 2;
	}

	new->planes = 1;	new->flags = 2;
	new->height = h;	new->width = w;

	if ((p = openplane(0, new, WRITE)) == NULL) return 3;
	for (line=0; line<h; ++line) {
		if (p_getline(rfile, w) != w) return 4;
		sp = linebuf(rfile);
		dp = p->linebuf;
		memcpy(dp, sp, w);
		if (putline(p) != w) return 3;
	}
	p_close(rfile);
	closeplane(p);
	histvalid = 0;
	return 0;
}

int saverix(int ac, argument *av)
{
	pl_printf(unimp);
	if (transpend) return 8;
	if (new->planes == 0) return 7;
	return 0;
}

static char *rawfiles[] = { "R8", "G8", "B8" };

int loadraw(int ac, argument *av)
{
	U32 mem;
	struct _plane *op;
	int r, i, pfile, np;
	U16 lines, h, w;
	U8 *pbuf;
	char *path;

	histvalid = 0;
	if (ac < 4) {
		pl_printf("Syntax is [R]LOAD <filename> <width> <height> [COLOR | MONO].\r\n");
		return 0;
	} else {
		if (ac > 5) pl_warn(1);
		if (ac == 5 && *av[4].cval == 'M') np = 1; else np = 3;
		w = (U16)av[2].fval;	if (w <= 0) return 9;
		h = (U16)av[3].fval;	if (h <= 0) return 9;
	}

	if ((pbuf = (U8 *)talloc(BUFSIZE + w)) == NULL) return 2;
	pl_printf(reading, av[1].cval);
	if ((r = begintransform()) != 0) return r;
	new->width = w; new->height = h; new->flags = 0; new->planes = (U8)np;

	mem = mark();
	for (i=0; i < np; ++i) {
		path = makepath(picdir, av[1].cval, rawfiles[i]);
		if ((pfile = p_open(path, pbuf, BUFSIZE, w, READ)) < 0) return 10;
		if ((op = openplane(i, new, WRITE)) == NULL) return 3;
		for (lines=0; lines<h; ++lines) {
			if (p_getline(pfile, w) == 0) return 4;
			memcpy(op->linebuf, linebuf(pfile), w);
			if (putline(op) == 0) return 3;
		}
		closeplane(op);
		p_close(pfile);
		release(mem);
	}
	return 0;
}

int saveraw(int ac, argument *av)
{
	return 0;
	if (transpend) return 8;
	if (new->planes == 0) return 7;
}

int loadip(int ac, argument *av)
{
	U32 mem;
	struct _plane *op;
	int r, i, np, pfile;
	U16 lines, h, w;
	U8 *pbuf;
	char *path;

	histvalid = 0;
	if (ac < 4) {
		pl_printf("Syntax is LOAD <filename> <width> <height> [COLOR | MONO].\r\n");
		return 0;
	} else {
		if (ac > 5) pl_warn(1);
		if (ac == 5 && *av[4].cval == 'M') np = 1; else np = 3;
		w = (U16)av[2].fval;	if (w <= 0) return 9;
		h = (U16)av[3].fval;	if (h <= 0) return 9;
	}

	if ((pbuf = (U8 *)talloc(BUFSIZE + w)) == NULL) return 2;
	if ((pfile = p_open(path, pbuf, BUFSIZE, w, READ)) < 0) return 10;

	pl_printf(reading, path);
	if ((r = begintransform()) != 0) return r;
	new->width = w; new->height = h; new->flags = 0; new->planes = (U8)np;

	mem = mark();
	for (i=0; i < np; ++i) {
		if ((op = openplane(i, new, WRITE)) == NULL) return 3;
		for (lines=0; lines<h; ++lines) {
			if (p_getline(pfile, w) == 0) return 4;
			memcpy(op->linebuf, linebuf(pfile), w);
			if (putline(op) == 0) return 3;
		}
		closeplane(op);
		release(mem);
	}
	p_close(pfile);
	return 0;
}

int saveip(int ac, argument *av)
{
	pl_printf(unimp);
	if (transpend) return 8;
	if (new->planes == 0) return 7;
	return 0;
}
