	title	memory allocation
	include	asm.inc

	public	calloc		; allocate storage and initialize to zero
	public	free		; return storage to DOS
	public	malloc		; allocate uninitialized storage
	public	realloc		; change size of allocated storage

	.const
ertx_alloc_range	db	'alloc out of range',0

	.code
	extn	ms_dos_strerror,set_strerror


;;	calloc
;
;	entry	CX	requested byte count (1..FFF0)
;	exit	AX	actual byte count
;		ES:DI	storage pointer
;		Cf	if no storage
;
calloc	proc
	call	malloc			; allocate storage
	jc	cal1

	pushm	ax,cx,di		; zero storage
	mov	cx,ax
	movx	ax,0
	shr	cx,1
	rep	stosw
	popm	di,cx,ax
cal1:	ret
calloc	endp


;;	free
;
;	entry	ES:DI	storage pointer (OK if NULL)
;	exit	ES:DI	NULL
;		Cf	if bad pointer
;	uses	AX
;
free	proc
	mov	ax,es
	or	ax,di
	jz	fee1			;\ if NULL pointer - ignore call

	mov	ah,49h
	call	ms_dos_strerror

	mov	di,NULL_POINTER		; return NULL (don't modify flags)
	mov	es,di

fee1:	ret
free	endp


;;	malloc
;
;	entry	CX	requested byte count (1..FFF0)
;	exit	AX	actual byte count
;		ES:DI	storage pointer (unchanged if error)
;		Cf	if no storage
;
malloc	proc
	jcxz	mal2			; if byte count out of range
	mov	ax,cx
	add	ax,15
	jc	mal2			; if byte count out of range
	and	al,0F0h

	pushm	ax,bx			; convert byte count to paragraph cnt
	shr	ax,1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	bx,ax

	mov	ah,48h			; request memory from dos
	call	ms_dos_strerror
	jc	mal1			;  if not enough memory
	mov	es,ax
	movx	di,NULL_POINTER

mal1:	popm	bx,ax
	ret

mal2:	lea	ax,ertx_alloc_range	; *alloc out of range*
	jmp	set_strerror
malloc	endp


;;	realloc
;
;	entry	CX	requested byte count (1..FFF0)
;		ES:DI	storage pointer
;	exit	AX	actual byte count
;		Cf	if not enough memory or cannot increase size
;
realloc proc
	mov	ax,cx			; round up to multiple of 16
	add	ax,15
	jc	ral1			;  if out of range (>FFF0)
	jcxz	ral1			;  if out of range (<1)
	and	al,0F0h

	pushm	ax,bx			; bytes to paragraphs
	shr	ax,1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	bx,ax

	mov	ah,4Ah			; change storage size via DOS
	call	ms_dos_strerror		;  (very possible this will NOT work)
	popm	bx,ax
	ret

ral1:	lea	ax,ertx_alloc_range	; *alloc out of range*
	jmp	set_strerror
realloc endp

	end
