	title	strncpy
	include	asm.inc

	public	strncpy

	.code

;;	strncpy
;
;	entry	DS:SI	source string
;		ES:DI	destination buffer
;		CX	byte count (includes room for \0)
;	exit	SI	updated (past \0 unless CX too small)
;		DI	updated (points to \0)
;		CX	updated
;	uses	AX
;
strncpy proc
	jcxz	snc3			; if no space in destination

snc1:	lodsb				; copy string
	stosb
	cmp	al,NULL_CHAR
	loopne	snc1
	je	snc2			;  if end of source string

	dec	di			;  else backup destination and
	mov	al,NULL_CHAR		;   delimit string
	stosb

snc2:	dec	di
snc3:	ret
strncpy endp

	end
