	include	asm.inc

	public	read_entire_file

	.const
	public	ertx_file_too_big
ertx_file_too_big	db	'File too big',0

	.code
	extn	open_input_file,current_file_size,malloc,rewind
	extn	read_from_file,close_file,set_strerror


;;	read entire file
;
;	entry	DS:SI	asciiz file name
;	exit	DS:SI	ptr to storage containing file (NULL delimited)
;		CX	file byte count
;		Cf	if file not found or too big
;	uses	AX
;
read_entire_file proc
	pushm	bx,dx,di,es
	call	open_input_file
	jc	ref2			; if file not found

	call	current_file_size
	jc	ref1

	or	dx,dx			; check file size
	jnz	ref3			;  if file too big
	cmp	ax,0FFF0h
	jae	ref3			;  if file too big

	mov	cx,ax			;  allocate storage for file contents
	inc	cx			;   (account for delimiter)
	call	malloc
	jc	ref1			;  if no memory

	call	rewind
	jc	ref1

	mov	cx,-1
	call	read_from_file
	jc	ref1			;  if unexpected file i/o error

	mov	cx,ax			; return file byte count
	mov	si,di			;  and storage pointer
	push	es
	pop	ds

	add	di,ax			; delimit file with NULL
	mov	al,NULL_CHAR
	stosb

ref1:	pushf
	call	close_file
	popf
ref2:	popm	es,di,dx,bx
	ret

ref3:	lea	ax,ertx_file_too_big	; *file too big*
	call	set_strerror
	jmp	ref1
read_entire_file endp

	end
