	title	ms_dos_strerror - ms_dos interface that sets error string
	include	asm.inc

	public	ms_dos_strerror

	.const
error_strings	dw	ertx_invalid_function,	 ertx_file_not_found
		dw	ertx_path_not_found,	 ertx_no_handles_left
		dw	ertx_access_denied,	 ertx_invalid_handle
		dw	ertx_memory_destroyed,	 ertx_not_enough_memory
		dw	ertx_invalid_memory_blk, ertx_invalid_environ
		dw	ertx_invalid_format,	 ertx_invalid_access_cod
		dw	ertx_invalid_data,	 err14
		dw	ertx_invalid_drive,	 ertx_del_current_dir
		dw	ertx_not_same_device,	 ertx_no_more_files

ertx_invalid_function	db	'Invalid function',0
ertx_file_not_found	db	'File not found',0
ertx_path_not_found	db	'Path not found',0
ertx_no_handles_left	db	'No handles left',0
ertx_access_denied	db	'Access denied',0
ertx_invalid_handle	db	'Invalid handle',0
ertx_memory_destroyed	db	'Memory ctrl blks destroyed',0
ertx_not_enough_memory	db	'Not enough memory',0
ertx_invalid_memory_blk	db	'Invalid memory blk adr',0
ertx_invalid_environ	db	'Invalid environment',0
ertx_invalid_format	db	'Invalid format',0
ertx_invalid_access_cod	db	'Invalid access code',0
ertx_invalid_data	db	'Invalid data',0
err14			db	'?',0
ertx_invalid_drive	db	'Invalid drive',0
ertx_del_current_dir	db	'Deleting current dir',0
ertx_not_same_device	db	'Not same device',0
ertx_no_more_files	db	'No more files',0
MAX_ERROR_CODE	equ	18

 public ertx_invalid_function,ertx_file_not_found,ertx_path_not_found
 public ertx_no_handles_left,ertx_access_denied,ertx_invalid_handle
 public ertx_memory_destroyed,ertx_not_enough_memory,ertx_invalid_memory_blk
 public ertx_invalid_environ,ertx_invalid_format,ertx_invalid_access_cod
 public ertx_invalid_data,ertx_invalid_drive,ertx_del_current_dir
 public ertx_not_same_device,ertx_no_more_files

	.code
	extn	ms_dos,set_strerror


;;	ms dos strerror
;
ms_dos_strerror proc
	call	ms_dos
	jc	mde1			;  if error during dos function
	ret

mde1:	push	ax
	cmp	ax,MAX_ERROR_CODE
	ja	mde2			;  if error code too high
	add	ax,ax
	jz	mde2			;  if error code too low  (AX==0)

	xchg	ax,si			; set error string
	mov	si,error_strings[bp+si-2]
	xchg	ax,si
	call	set_strerror

mde2:	stc
	pop	ax
	ret
ms_dos_strerror endp

	end
