/* herctest.c: Test routines for the line-drawing routine in
 *    hercline.asm.  Test the line-drawing routine extensively,
 *    using the library routine as the standard, and report on
 *    the relative performance compared to the library routine.
 */

#include <stdio.h>
#include <conio.h>
#include <graphics.h>
#include <stdlib.h>
#include <dos.h>
#include <time.h>
#include <math.h>

/* Number of repetitions to do in the beginning */
#define NUM_REPS 1000

extern void hercline(int x1, int y1, int x2, int y2, int clr);

/* Routine to calculate the number of hundredths of seconds in
   a given time structure. */
long
num_hunds(struct time *a)
{
  long hrs, mins, secs;
  hrs = a->ti_hour * 360000L;
  mins = a->ti_min * 6000L;
  secs = a->ti_sec * 100L;
  return(hrs + mins + secs + (long) a->ti_hund);
}

/* Routine to calculate the number of hundredths of seconds
   between two given time structures. */
long
diff_time(struct time *beg, struct time *end)
{
  return(num_hunds(end) - num_hunds(beg));
}

/* Empty routine.  Used by do_test(). */
void
just_return(int x1, int y1, int x2, int y2, int clr)
{
  return;
}

void
do_test(int which)
{
  int x1, y1, x2, y2, clr;
  long i;

  for (i = 0; i < NUM_REPS; i++) {
    x1 = rand() % 720;
    y1 = rand() % 348;
    x2 = rand() % 720;
    y2 = rand() % 348;
    switch(which) {
      case 0:
	just_return(x1, y1, x2, y2, clr);
	break;
      case 1:
	hercline(x1, y1, x2, y2, 1);
	break;
      case 2:
	line(x1, y1, x2, y2);
	break;
      case 3:
	hercline(x1, y1, x2, y2, 0);
      default:
	break;
    }
  }
}

void main(void)
{
  int dr, md;
  char cmd;
  struct time beg, end;
  long hunds_blank, hunds_lib, hunds_newline;
  int i;
  int seed;
  long now;
  long len;

  dr = md = 0;
  registerbgidriver(Herc_driver);
  initgraph(&dr, &md, "C:\LIB");

  seed = time(&now) % 37;

/* Time empty loop */
  srand(seed);	gettime(&beg);	do_test(0);  gettime(&end);
  hunds_blank = diff_time(&beg, &end);

/* Time our assembler routine */
  srand(seed);	gettime(&beg);	do_test(1);  gettime(&end);
  hunds_newline = diff_time(&beg, &end);

/* Time library routine */
  srand(seed);	gettime(&beg);	do_test(2);  gettime(&end);
  hunds_lib = diff_time(&beg, &end);
  srand(seed);
  do_test(3);

  restorecrtmode();
  printf("Dead time: %ld\n", hunds_blank);
  printf("New line: %ld\n", hunds_newline);
  printf("Library routine: %ld\n", hunds_lib);
  hunds_newline -= hunds_blank;
  hunds_lib -= hunds_blank;
  printf("New line is %.2f times as fast as library routine\n",
	 (float) hunds_lib / hunds_newline);
  printf("(hit any key to continue)\n");
  cmd = getch();
  setgraphmode(md);
  for (i = 0; i < 347; i++) {
    hercline(347-i, 0, 0, i, 1);
    hercline(347-i, 347, 0, 347-i, 1);
    hercline(371+i, 0, 719, i, 1);
    hercline(371+i, 347, 719, 347-i, 1);
  }
  /* Fill screen */
  for (i = 0; i < 347; i++)
    hercline(0, i, 719, i, 1);

  for (i = 0; i < 347; i++) {
    hercline(347-i, 0, 0, i, 0);
    hercline(347-i, 347, 0, 347-i, 0);
    hercline(371+i, 0, 719, i, 0);
    hercline(371+i, 347, 719, 347-i, 0);
  }
  for (i = 0; i < 347; i++)
    hercline(0, i, 719, i, 0);
  closegraph();
}
