	include	asm.inc

	public	save_most

	.code

;;	restore most
;
;	note	never call this routine
;
restore_most proc
	popm	bp,es,ds,si,di,dx,cx,bx
	ret
restore_most endp

	even
;;	save most
;
;	note	saves all registers except AX and BP.  however, the current
;		version also saves BP because the code works out that way.
;		the registers are automatically restored.  this routine is
;		called with a return address as the top of stack.
;
save_most proc				; +16 inner ret adr, +18 outer ret adr
	push	cx			; +14
	push	dx			; +12
	push	di			; +10
	push	si			; +8
	push	ds			; +6
	push	es			; +4
	push	bp			; +2
	lea	bp,restore_most		;     after execution of inner
	push	bp			; +0  routine, return to restore_most
	mov	bp,sp
	xchg	bx,[bp+16]		;	bx above cx
	push	bx			; -2	setup return to inner routine
	mov	bx,[bp+16]		;	restore original BX and BP
	mov	bp,[bp+2]
	ret
save_most endp

	end
