	.xlist
	page	63,128

	.model	small
	ASSUME	ds:nothing
	includelib alib


bptr			equ	byte ptr
wptr			equ	word ptr
dptr			equ	dword ptr

stdin			equ	0
stdout			equ	1
stderr			equ	2

EXIT_SUCCESS		equ	0
EXIT_FAILURE		equ	1

FILENAME_MAX		equ	80
FOPEN_MAX		equ	20

ZER0			equ	0

NULL_POINTER		equ	0
NULL_HANDLE		equ	0

NULL_CHAR		equ	0
BEL_CHAR		equ	7
BS_CHAR			equ	8
TAB_CHAR		equ	9
HT_CHAR			equ	9
NL_CHAR			equ	10
LF_CHAR			equ	10	; linefeed
VT_CHAR			equ	11
FF_CHAR			equ	12
CR_CHAR			equ	13	; carriage return
ESC_CHAR		equ	27
SPACE_CHAR		equ	' '

NEWLINE_CHARS		equ	0A0Dh

BLOCK_SIZE		equ	16384	; size of an EMS block

DGROUP_REGISTER		equ	ss	; this register assumed to be DGROUP


; MACROs

; smart CMP marco
;
cmpx	macro	dst,src
	if	src eq 0
	or	dst,dst
	else
	cmp	dst,src
	endif
	endm


; smart MOV macro
;
movx	macro	dst,src
	ifidn	<src>,<DGROUP_SEGMENT>
	push	ss
	pop	dst
	exitm
	endif

	if	(type src) eq 0			; if register or constant AND
	if	((.type src) and 11100b) eq 0	; if not any register	  AND
	if	src eq 0			; if source is zero
	sub	dst,dst				; then efficiently 0 register
	exitm
	endif
	endif
	endif

	mov	dst,src
	endm


; OPTASM macros
;
	IFNDEF	.date	; if not OPTASM
	.sall		; don't show macro contents

extb	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	extrn	xx:byte
	else
	exitm
	endif
	endm
	endm

extd	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	extrn	xx:dword
	else
	exitm
	endif
	endm
	endm

extn	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	extrn	xx:near
	else
	exitm
	endif
	endm
	endm

extw	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	extrn	xx:word
	else
	exitm
	endif
	endm
	endm

pushm	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	push	xx
	else
	exitm
	endif
	endm
	endm

popm	macro	a,b,c,d,e,f,g,h,i,j,k
	irp	xx,<a,b,c,d,e,f,g,h,i,j,k>
	ifnb	<xx>
	pop	xx
	else
	exitm
	endif
	endm
	endm

	ENDIF		; end MASM/TASM macros

	.list		; end of asm.inc
