/*
** KBDEDIT.C: Lets the user edit a string using kbdedit.
*/

#include <stdio.h>
#include <pictor.h>

COLORSTRUCT colors = {
   foreback(BLACK,WHITE),
   0x00,  /* not used by kbdedit() */
   foreback(WHITE,BLACK),
   0x00   /* not used by kbdedit() */
};

char buffer[128];

void main()
{
   int i;

   /* initialize library */
   initvideo();

   /* clear screen */
   vcolor(foreback(BOLD+WHITE,BLUE));
   cls();

   setvpos(3,5);
   vputs("KbdEdit: [");
   setvpos(3,15 + 25);
   vputc(']');

   i = kbdedit(buffer,3,15,25,127,&colors);

   /* restore screen */
   vcolor(foreback(WHITE,BLACK));
   cls();

   /* print result */
   if(i == TRUE)
      printf("You entered: %s\n",buffer);
   else
      printf("You pressed <Escape>\n");

}

