/*
** vh.c
**
** View-Help, Help file viewer utility.
** Compile with any memory model but large data (compact
** or large) provides more run-time memory.
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <stdlib.h>
#include <pictor.h>

char copyright[] =
	"VH - View-Help, Version 1.51, Copyright (c) 1992-94 SoftCircuits";

COLORSTRUCT hlpcolors = {
	foreback(BLACK,WHITE),
	foreback(BOLD|WHITE,WHITE),
	foreback(WHITE,BLACK),
	foreback(BLACK,BLACK)
};

COLORSTRUCT msgcolors = {
	foreback(BLACK,CYAN),
	foreback(BOLD|WHITE,CYAN),
	foreback(WHITE,BLACK),
	foreback(BOLD|WHITE,BLACK)
};

COLORSTRUCT bwcolors = {
	foreback(WHITE,BLACK),
	foreback(BOLD|WHITE,BLACK),
	foreback(BLACK,WHITE),
	foreback(WHITE,BLACK)
};

int screen_color = foreback(BOLD|CYAN,BLUE);
int status_color = foreback(BLACK,CYAN);
VIDEOSTRUCT vs;

/*
** Show command line options and exit.
*/
void showusage()
{
	printf("%s\n",copyright);
	printf("Redistributed by permission.\n\n");
	printf("Usage:\tVH <options> <hlpfile>\n\n");
	printf("Valid options:\n");
	printf("/b\tBlack and white. Suppress colors.\n");
	printf("/q\tQuick video (CGA only).\n");

	exit(1);

} /* showusage */

void main(int argc,char *argv[])
{
	int i,blkwht = FALSE,qckvid = FALSE;
	char *fname = NULL;

	for(i = 1;i < argc;i++) {
		switch(argv[i][0]) {
			case '-':
			case '/':
				switch(argv[i][1]) {
					case 'b':
					case 'B':
						blkwht = TRUE;
						break;
					case 'q':
					case 'Q':
						qckvid = TRUE;
						break;
				}
				break;
			default:
				if(fname == NULL)
					fname = argv[i];
				else
					showusage();
				break;
		}
	}
	if(fname == NULL) showusage();

	initvideo();
	getvconfig(&vs);

	if(!vs.colorsupport || blkwht) {
		hlpcolors.normal = bwcolors.normal;
		hlpcolors.boldnormal = bwcolors.boldnormal;
		hlpcolors.select = bwcolors.select;
		hlpcolors.boldselect = bwcolors.boldselect;
		msgcolors.normal = bwcolors.normal;
		msgcolors.boldnormal = bwcolors.boldnormal;
		msgcolors.select = bwcolors.select;
		msgcolors.boldselect = bwcolors.boldselect;
		screen_color = foreback(WHITE,BLACK);
		status_color = foreback(BLACK,WHITE);
	}
	if(qckvid) snowcheckoff();

	vcolor(screen_color); cls();
	vcolor(status_color); setvpos(1,1); vrepc(' ',vs.columns);
	setvpos(1,center(strlen(copyright),vs.columns)); vputs(copyright);

	hookints(&msgcolors);
	initstatus(vs.rows,status_color);

	helpopen(fname,&hlpcolors,&msgcolors);
	helprun(NULL);

	vcolor(foreback(WHITE,BLACK));
	cls();

} /* main */


