/*
** XPRINTF.C: Displays a window with information about the
** current display configuration.
*/

#include <pictor.h>

void main()
{
   VIDEOSTRUCT vstruct;

   /* initialize library */
   initvideo();
   getvconfig(&vstruct);

   /* create window and write information */
   wopen(6,11,11,60,foreback(BOLD+WHITE,BLUE),0x00);
   xprintf(wputs,"Video segment: %04X\n",vstruct.segment);
   xprintf(wputs,"Snow checking: %s\n",
      (vstruct.snowcheck) ? "On" : "Off");
   xprintf(wputs,"Text rows: %d\n",vstruct.rows);
   xprintf(wputs,"Text columns: %d\n",vstruct.columns);
   xprintf(wputs,"Video mode: %d\n",vstruct.mode);
   xprintf(wputs,"Display page: %d\n",vstruct.page);
   xprintf(wputs,"Color support: %s\n",
      (vstruct.colorsupport) ? "Yes" : "No");
   wputs("\nPress any key...");

   /* wait for user to press a key and close the window */
   kbdread();
   wclose();
}
