/*
** MULTEDIT.C: Uses multiedit to display a dialog box with
** multiple edit fields.
*/

#include <stdio.h>
#include <pictor.h>

#define MAX_LEN		25
char buff1[MAX_LEN + 1];
char buff2[MAX_LEN + 2];

#define NUM_ITEMS	2
MEDITSTRUCT items[NUM_ITEMS] = {
   { "Find What",buff1,MAX_LEN },
   { "Replace with",buff2,MAX_LEN }
};

COLORSTRUCT colors = {
   foreback(BLACK,WHITE),
   foreback(BOLD+WHITE,WHITE),
   foreback(WHITE,BLACK),
   foreback(BOLD+WHITE,BLACK)
};

void main()
{
   char buffer[81];

   /* initialize library */
   initvideo();

   if(multiedit(items,NUM_ITEMS,"Replace",&colors)) {
      sprintf(buffer,"You entered:\n\"%s\"\nand:\n\"%s\"",
         buff1,buff2);
      messagebox(buffer,NULL,MB_OK,&colors);
   }
   else {
      messagebox("You pressed <Escape>",NULL,MB_OK,
         &colors);
   }
}
