/*
** wpane.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <stdlib.h>
#include "pictor.h"


/*
** Selects the active window pane.
*/
int setwpane(int handle)
{
	if(_PL_winhead == NULL || handle < 0 || handle >= _PL_winhead->numpanes)
		return(FALSE);

	_PL_winhead->currpane = handle;
	if(_PL_winhead->style & WO_TEXTCURSOR)
		wsynccurs();

	return(TRUE);

} /* setwpane */

static char split_top[][2] = {
	{ '\xCD','\xD1' },
	{ '\xC4','\xC2' },
	{ '\xC1','\xC5' },
	{ '\x00',' ' }
};

static char split_bottom[][2] = {
	{ '\xCD','\xCF' },
	{ '\xC4','\xC1' },
	{ '\xC2','\xC5' },
	{ '\x00',' '}
};

static char split_left[][2] = {
	{ '\xBA','\xC7' },
	{ '\xB3','\xC3' },
	{ '\xB4','\xC5' },
	{ '\x00',' ' }
};

static char split_right[][2] = {
	{ '\xBA','\xB6' },
	{ '\xB3','\xB4' },
	{ '\xC3','\xC5' },
	{ '\x00',' ' }
};

char lookup_char(char (*table)[2])
{
	int i;
	char c;

	c = (char)(vgetca() & 0xFF);

	_PL_offset -= 2;

	for(i = 0;table[i][0] != '\x00';i++) {
		if(c == table[i][0])
			return(table[i][1]);
	}
	return(table[i][1]);

} /* lookup_char */

/*
** Divides the active window pane into 2 panes. NOTE: windows
** with the WO_STATICMEM attribute cannot have multiple panes.
** Returns a handle to the new pane, or 0 if the pane could not
** be created.
*/
int wpane(int direction,int split)
{
	PANESTRUCT *oldpane,*newpane;
	WINDOW *win;
	int i;

	win = _PL_winhead;

	if(win == NULL || win->style & WO_STATICMEM)
		return(0);


	if(direction == WP_HORIZONTAL) {
		if(split < 3 || split > getwrows())
			return(0);
	}
	else if(direction == WP_VERTICAL) {
		if(split < 3 || split > getwcols())
			return(0);
	}
	else return(0);

	win = realloc(_PL_winhead,
		sizeof(WINDOW) + (sizeof(PANESTRUCT) * _PL_winhead->numpanes));

	if(win == NULL)
		return(0);
	else
		_PL_winhead = win;

	oldpane = (win->panes + win->currpane);
	newpane = (win->panes + win->numpanes);
	win->numpanes++;

	vcolor(win->color);

	if(direction == WP_HORIZONTAL) {
		newpane->left = oldpane->left;
		newpane->width = oldpane->width;
		newpane->color = oldpane->color;
		newpane->top = (oldpane->top + (split - 1));
		newpane->height = (oldpane->height - (split - 1));
		oldpane->height = split;

		setvpos(newpane->top,newpane->left);
		vputc(lookup_char(split_left));
		vrepc('\xC4',newpane->width - 2);
		vputc(lookup_char(split_right));
	}
	else {   /* WP_VERTICAL */
		newpane->top = oldpane->top;
		newpane->height = oldpane->height;
		newpane->color = oldpane->color;
		newpane->left = (oldpane->left + (split - 1));
		newpane->width = (oldpane->width - (split - 1));
		oldpane->width = split;

		setvpos(newpane->top,newpane->left);
		vputc(lookup_char(split_top));
		for(i = 0;i < newpane->height - 2;i++) {
			setvpos(newpane->top + 1 + i,newpane->left);
			vputc('\xB3');
		}
		setvpos(newpane->top + 1 + i,newpane->left);
		vputc(lookup_char(split_bottom));
	}

	/* clear new pane */
	i = win->currpane;
	win->currpane = (win->numpanes - 1);
	wclear();
	win->currpane = i;

	return(win->numpanes - 1);

} /* wpane */
