/*
** setctype.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <dos.h>
#include "pictor.h"

/*
** Sets the text cursor start and end scan lines.
*/
void setcurstype(int type)
{
	union REGS regs;

	regs.h.ah = 0x01;
	regs.x.cx = type;
	int86(0x10,&regs,&regs);

} /* setcurstype */

/*
** Gets the text cursor start and end scan lines.
*/
int getcurstype(void)
{
	union REGS regs;

	regs.h.ah = 0x03;
	regs.h.bh = (unsigned char)_PL_page;
	int86(0x10,&regs,&regs);

	return(regs.x.cx);

} /* getcurstype */
