/*
** pause.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <bios.h>
#include "pictor.h"

/*
** Suspends program execution for the specified duration.
*/
void pause(int duration)
{
	long curtime,endtime;

	_bios_timeofday(_TIME_GETCLOCK,&curtime);
	endtime = (curtime + (long)duration);

	while(curtime < endtime) {
		if(_bios_timeofday(_TIME_GETCLOCK,&curtime))
			endtime -= 1573040L;
	}

} /* pause */
