/*
** kbdread.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <dos.h>
#include "pictor.h"

int _PL_pushedkey = 0;
int _PL_escape = FALSE;

/*
** Returns the next available keystroke with the ASCII character
** in the low byte and the scan code in the high byte.
*/
int kbdread(void)
{
	union REGS regs;

	if(_PL_pushedkey != 0) {
		regs.x.ax = _PL_pushedkey;
		_PL_pushedkey = 0;
	}
	else {
		regs.h.ah = 0x00;
		int86(0x16,&regs,&regs);
		if(regs.x.ax == 0x0000)  /* ctrl-break */
			regs.x.ax = 0xFFFF;
	}
	/* indicate if last key read was escape */
	_PL_escape = (regs.x.ax == ESCAPE_KEY);
	return(regs.x.ax);

} /* kbdread */
