/*
** frame.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include "pictor.h"

#define HORIZONTAL      0
#define VERTICAL        1
#define TOP_LEFT        2
#define TOP_RIGHT       3
#define BOTTOM_LEFT     4
#define BOTTOM_RIGHT    5

/* define default frame characters */
static char fchars[6] = { '\xCD','\xBA','\xC9','\xBB','\xC8','\xBC' };


/*
** Sets the frame type using the frame character arguments.
*/
void setframe(char horiz,char vert,char tl,char tr,char bl,char br)
{
	fchars[HORIZONTAL] = horiz;
	fchars[VERTICAL] = vert;
	fchars[TOP_LEFT] = tl;
	fchars[TOP_RIGHT] = tr;
	fchars[BOTTOM_LEFT] = bl;
	fchars[BOTTOM_RIGHT] = br;

} /* setframe */

/*
** Draws a box using the current frame type.
*/
void frame(int top,int left,int height,int width)
{
	int row = top;

	/* draw top of frame */
	setvpos(top,left);
	vputc(fchars[TOP_LEFT]);
	vrepc(fchars[HORIZONTAL],width - 2);
	vputc(fchars[TOP_RIGHT]);

	/* draw sides */
	for(row = 1;row < height;row++) {
		setvpos(top + row,left);
		vputc(fchars[VERTICAL]);
		setvpos(top + row,left + (width - 1));
		vputc(fchars[VERTICAL]);
	}

	/* draw bottom */
	setvpos(top + (height - 1),left);
	vputc(fchars[BOTTOM_LEFT]);
	vrepc(fchars[HORIZONTAL],width - 2);
	vputc(fchars[BOTTOM_RIGHT]);

} /* frame */
