/*
** comlib.h
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#ifndef COMLIB_H
#define COMLIB_H

#define CO_COM1         0x0000
#define CO_COM2         0x0001
#define CO_COM3         0x0002
#define CO_COM4         0x0003
#define CO_NOPARITY     0x0000
#define CO_ODDPARITY    0x0008
#define CO_EVENPARITY   0x0018
#define CO_DATA7        0x0002
#define CO_DATA8        0x0003
#define CO_STOP1        0x0000
#define CO_STOP2        0x0004
#define CO_BAUD300      0x0180
#define CO_BAUD1200     0x0060
#define CO_BAUD2400     0x0030
#define CO_BAUD4800     0x0018
#define CO_BAUD9600     0x000C
#define CO_BAUD19200    0x0006
#define CO_BAUD38400    0x0003
#define CO_BAUD57600    0x0002
#define CO_BAUD115200   0x0001
#define CO_IRQDEFAULT   0x0000
#define CO_IRQ2         0x0002
#define CO_IRQ3         0x0003
#define CO_IRQ4         0x0004
#define CO_IRQ5         0x0005

extern int _PL_comtimeout;
extern int _PL_comoverflow;

#define comgettimeout() (_PL_comtimeout)
#define comsettimeout(_x) (_PL_comtimeout = (_x))

int  comclose(void);
int  comflush(void);
int  comgetc(char *);
int  comgets(char *,int);
int  comloc(void);
int  comopen(int,int,int,int,int,int);
int  computc(char);
int  computs(char *);
int  comread(char *,int);
int  comwrite(char *,int);

#endif
