/*
** ed.h
**
** Ed, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

/* data structure for line buffers */
typedef struct _LINE {
	struct _LINE *prev;	/* pointer to previous line */
	struct _LINE *next;	/* pointer to next line */
	int len;             /* length of line */
	char text[1];        /* line text */
} LINE;

#define UPDATE_NOUPDATE   0
#define UPDATE_REPAINT    1
#define UPDATE_SCROLLUP   2
#define UPDATE_SCROLLDN   3

#define NEXT_TAB(_c) (_c + (tab_size - (_c % tab_size)))

#define CTRL_PGUP 	0x8400
#define CTRL_PGDN    0x7600
#define CTRL_HOME    0x7700
#define CTRL_END     0x7500
#define CTRL_Y       0x1519
#define CTRL_F1      0x5E00
#define CTRL_F2      0x5F00

#define EDIT_ROWS		((edit_bottom - edit_top) + 1)
#define EDIT_COLS		((edit_right - edit_left) + 1)

extern int edit_top,edit_bottom,edit_left,edit_right;

extern LINE *head;
extern LINE *tail;
extern LINE *curr_line;
extern LINE *top_line;

extern int tab_size;
extern int insert_mode;
extern int num_lines;
extern int line_ndx;
extern int file_row;
extern int file_col;
extern int pref_col;
extern int top_row;
extern int left_col;
extern int update_state;
extern int modified;

extern char *copyright;
extern MAINMENU mainmenu[];
extern char filename[];
extern char untitled[];
extern char buffer[];

extern VIDEOSTRUCT vcfg;
extern COLORSTRUCT msgcolors;
extern COLORSTRUCT mnucolors;
extern int edit_color;
extern int status_color;
extern int message_color;

/* help topics */
extern char hlp_general[];
extern char hlp_new[],hlp_open[],hlp_save[],hlp_saveas[];
extern char hlp_print[],hlp_exit[];
extern char hlp_find[],hlp_change[],hlp_repeatfind[];
extern char hlp_tabwidth[];
extern char hlp_usinghlp[],hlp_index[],hlp_about[];
extern char hlp_filemenu[],hlp_searchmenu[];
extern char hlp_optionsmenu[],hlp_helpmenu[];


/* ed.c prototypes */
void outofmemory();
int expand_line(LINE **,int,int);
void shrink_line(LINE **,int,int);
void split_line(void);
void join_line(void);
void delete_line(void);
void delete_char(void);
void backspace_char(void);
void insert_char(char c);
void show_usage(void);
void terminate(void);

/* navigate.c prototypes */
void show_status(void);
void show_line(LINE *,int);
void show_text(void);
void set_file_col(void);
void set_line_ndx(void);
void update_cursor(int);
void _left(void);
void _right(void);
void _up(void);
void _down(void);
void cursor_left(void);
void cursor_right(void);
void cursor_up(void);
void cursor_down(void);
void page_up(void);
void page_down(void);
void file_home(void);
void file_end(void);

/* buffers.c prototypes */
void free_list(void);
void remove_from_list(LINE *);
void add_to_list(LINE *,LINE *);
void append_line(LINE *);
void new_file(char *);
void load_file(char *);
int save_file(char *);

/* commands.c */
void using_help(void);
void help_index(void);
void about(void);
void set_tabwidth(void);
int save_modified(void);
void filenew(void);
void fileopen(void);
void filesave(void);
void filesaveas(void);
void fileprint(void);
void search(void);
void change(void);
void repeatsearch(void);
