/*
** data.c
**
** Ed, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <pictor.h>
#include "ed.h"

char *copyright = "Ed, Version 1.51, Copyright (c) 1992-94 SoftCircuits\n"
	"Redistributed by permission";

/* help topics */
char hlp_general[] = "General Help";
char hlp_new[] = "New";
char hlp_open[] = "Open";
char hlp_save[] = "Save";
char hlp_saveas[] = "Save As";
char hlp_print[] = "Print";
char hlp_exit[] = "Exit";
char hlp_find[] = "Find";
char hlp_change[] = "Change";
char hlp_repeatfind[] = "Repeat Last Find";
char hlp_tabwidth[] = "Tab Width";
char hlp_usinghlp[] = "Using Help";
char hlp_index[] = "Help Index";
char hlp_about[] = "About";
char hlp_filemenu[] = "File Menu";
char hlp_searchmenu[] = "Search Menu";
char hlp_optionsmenu[] = "Options Menu";
char hlp_helpmenu[] = "Help Menu";

int edit_color = foreback(WHITE,BLACK);
int status_color = foreback(BLACK,WHITE);

COLORSTRUCT msgcolors = {
	foreback(WHITE,BLACK),
	foreback(BOLD|WHITE,BLACK),
	foreback(BLACK,WHITE),
	foreback(WHITE,BLACK),
};

COLORSTRUCT mnucolors = {
	foreback(BLACK,WHITE),
	foreback(WHITE,BLACK),
	foreback(WHITE,BLACK),
	foreback(BLACK,WHITE)
};

int edit_top = 2;
int edit_bottom = 24;
int edit_left = 1;
int edit_right = 80;
int modified = FALSE;

VIDEOSTRUCT vcfg;
char filename[81];

/* menu data */
SUBMENU filemenu[] = {
	{ "~New",
		"Create a new file",hlp_new,filenew },
	{ "~Open",
		"Open an existing file",hlp_open,fileopen },
	{ "~Save                 F2",
		"Save the current file to disk",hlp_save,filesave },
	{ "Save ~As         Ctrl-F2",
		"Save the current file with a different name",hlp_saveas,filesaveas },
	SUBMENU_DIVIDER,
	{ "~Print                F9",
		"Send the current file to the printer",hlp_print,fileprint },
	SUBMENU_DIVIDER,
	{ "E~xit",
		"Exit to DOS",hlp_exit,terminate },
	END_SUBMENU
};

SUBMENU searchmenu[] = {
	{ "~Find               F4",
		"Search for text",hlp_find,search },
	{ "~Change",
		"Search for text and replace it with other text",hlp_change,change },
	{ "~Repeat Last Find   F3",
		"Find next occurance of last search",hlp_repeatfind,repeatsearch },
	END_SUBMENU
};

SUBMENU optionsmenu[] = {
	{ "~Tab Width",
		"Set tab size",hlp_tabwidth,set_tabwidth },
	END_SUBMENU
};

SUBMENU helpmenu[] = {
	{ "~Help Using Help",
		"View help on using the help system",hlp_usinghlp,using_help },
	{ "Help ~Index        Ctrl-F1",
		"Select a help topic from the help index",hlp_index,help_index},
	SUBMENU_DIVIDER,
	{ "~About",
		"Display program version and copyright information",hlp_about,about},
	END_SUBMENU
};

MAINMENU mainmenu[] = {
	{ "~File",	"File operations menu",hlp_filemenu,filemenu },
	{ "~Search","Search operations menu",hlp_searchmenu,searchmenu },
	{ "~Options","Maintenance and miscellaneous operations menu",
		hlp_optionsmenu,optionsmenu },
	{ "~Help",	"Help and program information operations menu",
		hlp_helpmenu,helpmenu },
	END_MAINMENU
};
