/*
** UNCOMP.C: Uncompresses a file that was compressed with
** COMPRESS.C.
*/

#include <stdio.h>
#include <string.h>
#include <compress.h>

BYTE inbuff[BUFSIZ + 200];
BYTE outbuff[BUFSIZ];

void main(int argc,char *argv[])
{
   FILE *istream,*ostream;
   WORD complen,uncomplen;
   NODE *rootnode;

   /* check arguments */
   if(argc != 3 || !stricmp(argv[1],argv[2])) {
      printf("Usage:\tUNCOMP <infile> <outfile>\n");
      return;
   }

   /* open files */
   istream = fopen(argv[1],"rb");
   ostream = fopen(argv[2],"wt");
   if(istream == NULL || ostream == NULL) {
      printf("File error\n");
      return;
   }

   /* read and uncompress code tree */
   complen = getw(istream);
   fread(inbuff,sizeof(BYTE),complen,istream);
   rootnode = readtree(inbuff);
   if(rootnode == NULL) {
      printf("Out of memory\n");
      return;
   }

   /* uncompress data and write to file */
   while((uncomplen = getw(istream)) != 0) {
      complen = getw(istream);
      fread(inbuff,sizeof(BYTE),complen,istream);
      uncompress(inbuff,uncomplen,outbuff,rootnode);
      fwrite(outbuff,sizeof(BYTE),uncomplen,ostream);
   }

   fclose(istream);
   fclose(ostream);
}
