/*
** LISTBOX.C: Lets the user select from a list of items.
*/

#include <stdio.h>
#include <pictor.h>

#define NUM_ITEMS	7
char *items[NUM_ITEMS] = {
   "Apples",
   "Bananas",
   "Carrots",
   "Grapes",
   "Kiwi",
   "Raisins",
   "Watermelon",
};

COLORSTRUCT colors = {
   foreback(BOLD+CYAN,BLUE),
   foreback(BOLD+WHITE,CYAN),
   foreback(BLACK,WHITE),
   foreback(BOLD+WHITE,WHITE)
};

void main()
{
   char buffer[45];
   int sel = 0;

   /* initialize the library */
   initvideo();

   if(listbox(items,NUM_ITEMS,&sel,"Fruit",&colors)) {
      sprintf(buffer,"You selected %s",items[sel]);
      messagebox(buffer,NULL,MB_OK,&colors);
   }
   else {
      messagebox("You pressed <Escape>",NULL,MB_OK,
         &colors);
   }
}
