/*
** HELPRUN.C: Help file viewer.
*/

#include <stdio.h>
#include <pictor.h>

COLORSTRUCT helpcolors = {
   foreback(BLACK,WHITE),
   foreback(BOLD|WHITE,WHITE),
   foreback(WHITE,BLACK),
   foreback(BLACK,BLACK)
};

COLORSTRUCT msgcolors = {
   foreback(BLACK,CYAN),
   foreback(BOLD|WHITE,CYAN),
   foreback(WHITE,BLACK),
   foreback(BOLD|WHITE,BLACK)
};

void main(int argc,char *argv[])
{
   /* check command-line arguments */
   if(argc != 2) {
      printf("Usage:\tHELPRUN <hlpfile>\n");
      return;
   }

   /* initialize library */
   initvideo();

   cls();
   initstatus(25,helpcolors.normal);

   /* capture Ctrl-Break and critical error interrupts */
   hookints(&msgcolors);

   /* activate help system */
   helpopen(argv[1],&helpcolors,&msgcolors);

   /* run help starting with help index */
   helprun(NULL);

   /* restore screen */
   vcolor(foreback(WHITE,BLACK));
   cls();
}
