/*
** compress.h
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#ifndef COMPRESS_H
#define COMPRESS_H

#include <stdio.h>     /* for FILE definition */

typedef unsigned char BYTE;
typedef unsigned int WORD;

typedef struct _NODE {
	BYTE c;        /* character value */
	WORD freq;     /* occurances */
	struct _NODE *child0;  /* bit 0 child node */
	struct _NODE *child1;  /* bit 1 child node */
	struct _NODE *parent;  /* parent node */
} NODE;

/* compress.c */
NODE *gettree(FILE *);
WORD writetree(NODE *,BYTE *);
WORD compress(BYTE *,WORD,BYTE *,NODE *);

/* uncomp.c */
NODE *readtree(BYTE *);
void uncompress(BYTE *,WORD,BYTE *,NODE *);

/* freetree.c */
void freetree(NODE *);

#endif

