#ifndef DEF_PHFILE_H
#define DEF_PHFILE_H

#ifndef DEF_PHTYPES_H
#include "phtypes.h"
#endif

#ifndef DEF_TOPIC_H
#include "topic.h"
#endif

#ifndef DEF_HUFFNODE_H
#include "huffnode.h"
#endif

#ifndef DEF_LINEINFO_H
#include "lineinfo.h"
#endif

class PHelpFile
{
public:

	// Result codes returned by the open() member function.

	enum open_codes {
		NoError,		// Opened the file and allocated memory.
		AlreadyOpen,	// Already has an open file.
		BadFile,		// Missing or invalid file.
		NoMemory		// Cannot allocate enough memory.
		};

	PHelpFile();
	PHelpFile(const char*);
	~PHelpFile();

	int is_open();

	int hasContents();
	int hasIndex();
	int hasPrev();
	int hasNext();

	HelpCtx contentsCtx();
	HelpCtx indexCtx();
	HelpCtx prevCtx();
	HelpCtx nextCtx();
	HelpCtx currentCtx();

	int gotoContext(HelpCtx);

	void setWidth(int);
	int getLineCount();
	int getLinkCount();
	ushort getTextCount();
	char* text();
	HelpCtx contextOf(char*);
	int getMaxLineWidth();
	void getLine(char*, int, int);
	char* lineAddress(int, int&);
	void getTitle(char*, int);

	void suspend();
	int resume();

	static int isHelpFile(const char*);

	int open(const char*);
	void close();

protected:

	long search(ushort);
	void expand(char*, char*, ushort);
	void expand(char*, ushort);

	int fileSeek(long);
	int fileRead(void*, ushort);

	int handle;

	ulong ctxIndexPos;
	HelpCtx hcContents;
	HelpCtx hcIndex;
	HelpCtx curCtx;
	short huffRoot;

	Topic topic;
	char* textbuffer;
	char* ctextbuffer;
	HuffNode* huffbuffer;
	HelpCtx* linkbuffer;
	LineInfo* linebuffer;
	TitleString title;
	int textWidth;
	int maxLineWidth;
	int lineCount;

};

inline int PHelpFile::is_open()
{
	return (handle >= 0);
}

#endif	// DEF_PHFILE_H
