#ifndef DEF_PHTYPES_H
#define DEF_PHTYPES_H

// Define standard types used by PHELP.

typedef unsigned short ushort;
typedef unsigned char uchar;
typedef unsigned long ulong;
typedef char Identifier[33];

typedef unsigned short HelpCtx;
const HelpCtx BadCtx = 0xFFFFU;

typedef char TitleString[81];
typedef char IndexString[81];

// Notes:
//
// Identifier is a help context identifier, such as "hcContext", etc. By
//	default, an identifier is up to 32 characters in length; if you want to
//	support longer identifers, this is the place to adjust it.
//
// HelpCtx is a help context value (such as 1000). By default, a HelpCtx is
//	the same size used by TurboVision - an unsigned short, which allows
//	help context ranges of 0..65534 (0xFFFF is reserved). If you want to
//	extend the range of help context values, this is the place to do it.
//	Note that if you *do* change the type of HelpCtx, you will probably
//	need to also change the above definition of BadCtx.
//
// TitleString defines the size of a window title string (used in the
//	topic's TITLE command).
//
// IndexString defines the size of a topic INDEX string.

#endif	// DEF_PHTYPES_H
