#define Uses_PHelpApp
#define Uses_TPalette
#define Uses_TStatusLine
#define Uses_TRect
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TKeys
#define Uses_TEvent
#define Uses_PHelpFile
#define Uses_PHelpWindow
#define Uses_MsgBox
#include "PHStart.h"
#include <tv.h>
#include "PHEnd.h"

// Expand the application's palette to support the help window.
#define cpAppColor		cpColor cpPHelpColor
#define cpAppBlackWhite cpBlackWhite cpPHelpBlackWhite
#define cpAppMonochrome	cpMonochrome cpPHelpMonochrome

// Construct. Derived classes must set helpFileName to the name of the
//	help file.
PHelpApp::PHelpApp() :
	TProgInit(initStatusLine, initMenuBar, initDeskTop),
	helpFileName(0)
{
}

// Override the default palette so it support the help window.
TPalette& PHelpApp::getPalette() const
{
	static TPalette color(cpAppColor, sizeof(cpAppColor)-1);
	static TPalette blackwhite(cpAppBlackWhite, sizeof(cpAppBlackWhite)-1);
	static TPalette monochrome(cpAppMonochrome, sizeof(cpAppMonochrome)-1);
	static TPalette *palettes[] =
		{
		&color,
		&blackwhite,
		&monochrome
		};
	return *(palettes[appPalette]);
}

// Override the default statusline - add help commands.
TStatusLine* PHelpApp::initStatusLine(TRect r)
{
	r.a.y = r.b.y-1;
	return new TStatusLine(r,
	*new TStatusDef(0, 0xFFFF) +
		*new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
		*new TStatusItem(0, kbF10, cmMenu) +
		*new TStatusItem(0, kbF1, cmHelp) +
		*new TStatusItem(0, kbF5, cmZoom) +
		*new TStatusItem(0, kbCtrlF5, cmResize) +
		*new TStatusItem(0, kbAltF3, cmClose) +
		*new TStatusItem(0, kbAltF1, cmHelpBack)+
		*new TStatusItem(0, kbShiftF1, cmHelpIndex)
	);
}

// Override to process F1 keystrokes. Need to have this in getEvent() so
//	that we can process F1 presses while a pulldown menu is active.
void PHelpApp::getEvent(TEvent& event)
{
	TApplication::getEvent(event);

	if(event.what == evCommand && event.message.command == cmHelp)
		{
		// Don't help on the help window itself.
		if(!PHelpWindow::inUse)
			{
			// Create/open the help file.
			PHelpFile* file = new PHelpFile;
			int result = file->open(helpFileName);

			// Handle failure causes.
			if(result != PHelpFile::NoError)
				{
				delete file;
				if(result == PHelpFile::NoMemory)
					outOfMemory();
				else
					messageBox("Unable to open/access the help file.",
								mfError|mfOKButton);
				}
			else
				{
				// Create the help window and execute it.
				PHelpWindow* win = new PHelpWindow(file, event);
				if(validView(win))
					{
					execView(win);
					destroy(win);
					}
				delete file;
				}
			}
		clearEvent(event);
		}
}

void PHelpApp::handleEvent(TEvent& event)
{
	// Perform default application event processing.
	TApplication::handleEvent(event);

	// Handle help menu/statusline commands.
	if(event.what == evCommand)
		switch(event.message.command)
			{
			case cmHelpBack:
			case cmHelpIndex:
			case cmHelpContents:
				if(!PHelpWindow::inUse)	// shouldn't need this.
					{
					// Create the file.
					PHelpFile* file = new PHelpFile;
					int result = file->open(helpFileName);

					if(result != PHelpFile::NoError)
						{
						delete file;
						if(result == PHelpFile::NoMemory)
							outOfMemory();
						else
							messageBox("Unable to open/access the help file.",
										mfError|mfOKButton);
						}
					else
						{
						// Create the window and execute it.
						PHelpWindow* win = new PHelpWindow(file, event);
						if(validView(win))
							{
							execView(win);
							destroy(win);
							}
						delete file;
						}
					}
				clearEvent(event);
				break;
			}
}

