#ifndef DEF_PHELP_H
#define DEF_PHELP_H

const unsigned short hcBadContext = 0xFFFF;

#endif	// DEF_PHELP_H

#if defined(Uses_PHelpApp) && !defined(Def_PHelpApp)
#define Def_PHelpApp

class TRect;
class TEvent;
class TPalette;

class PHelpApp : public TApplication
{
public:

	PHelpApp();

	static TStatusLine* initStatusLine(TRect);

	virtual void getEvent(TEvent&);
	virtual void handleEvent(TEvent&);
	virtual TPalette& getPalette() const;

	const char* helpFileName;
};

#endif	// Uses_PHelpApp

#if defined(Uses_PHelpStack) && !defined(Def_PHelpStack)
#define Def_PHelpStack

class PHelpStack
{
public:

	PHelpStack(int=25);
	~PHelpStack();

	void push(ushort);
	ushort peek();
	ushort pop();
	void clear();
	int getCount();

protected:

	ushort* items;
	int count;
	int limit;
};

inline int PHelpStack::getCount()
{	return count;	}

#endif	// Uses_PHelpStack

#if defined(Uses_PHelpWindow) && !defined(Def_PHelpWindow)
#define Def_PHelpWindow

#define cpPHelpColor        "\x37\x3F\x3A" \
							"\x13\x13" \
							"\x30\x1E\x3E\x3F\x31\x3C\x4F" \
							"\x70\x78\x74\x20\x28\x24"

#define cpPHelpBlackWhite   "\x07\x0F\x07" \
							"\x70\x70" \
							"\x07\x0F\x70\x07\x0F\x07\x07" \
							"\x70\x78\x7F\x07\x07\x0F"

#define cpPHelpMonochrome   "\x07\x0F\x07" \
							"\x70\x70" \
							"\x07\x0F\x70\x07\x0F\x07\x07" \
							"\x07\x07\x0F\x70\x70\x70"

class PHelpFile;
class TEvent;
class TPalette;

class PHelpWindow : public TWindow
{
public:

	PHelpWindow(PHelpFile*, TEvent&);

	virtual TPalette& getPalette() const;
	virtual void handleEvent(TEvent&);
	virtual void setState(ushort, Boolean);
	virtual Boolean valid(ushort);
	void setTitle(const char*);

	static PHelpStack stack;
	static TRect bounds;
	static TRect zoomBounds;
	static Boolean inUse;
	Boolean isValid;
};

#endif	// Uses_PHelpWindow

#if defined(Uses_PHelpViewer) && !defined(Def_PHelpViewer)
#define Def_PHelpViewer

class TRect;
class TScrollBar;
class PHelpFile;

class PHelpViewer : public TScroller
{
public:

	PHelpViewer(const TRect&, TScrollBar*, TScrollBar*);

	virtual TPalette& getPalette() const;
	virtual void draw();
	virtual void changeBounds(const TRect&);
	virtual void handleEvent(TEvent&);
	void setFile(PHelpFile*);
	void makeVisible();

protected:

	void setCmds();
	void switchTopic();
	void selectKeyword(Boolean);
	void selectKeywordAt(const TPoint&);
	void selectBack();
	void selectIndex();
	void selectContents();
	void selectPrev();
	void selectNext();
	void selectCtx(ushort);

	char* findTextChar(ushort, uchar);
	char* revfindTextChar(ushort, uchar);

	PHelpFile* file;
	char* keyword;
};

#endif	// Uses_PHelpViewer

#if defined(Uses_PHelpMenuBar) && !defined(Def_PHelpMenuBar)
#define Def_PHelpMenuBar

class TRect;
class TSubMenu;
class TMenu;
class TPalette;

class PHelpMenuBar : public TMenuBar
{
public:

	PHelpMenuBar(const TRect&, TSubMenu&);
	PHelpMenuBar(const TRect&, TMenu*);

	virtual TPalette& getPalette() const;
};

#endif	// Uses_PHelpMenuBar

