///////////////////////////////////////////////////////////////////
// class for a "percentbar" - use it with the "MFC's"
//
// Norbert Gutbrod (Germany) - [100265,2327]
// Ver 1.0 / 04/30/94
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
// It can be used in a dialog, which contains a "Black Frame" and
// - if you want - a "Static Text"
//
// 1. Put it into your project
// 2. "#include" the header in your source
// 3. Construct the object
// 4. if you didn't use the 2nd constructor -> subclass it
// 5. put the "UpdatePercentBar()" in your "OnPaint" routine
// 6. call the "SetPercent()"...
// that's all
///////////////////////////////////////////////////////////////////

#include <afxwin.h>
#include "percbar.h"

// 1st constructor
CPercentBar::CPercentBar()
{
    m_pParent        = NULL;
    m_nFrameID       = 0;
    m_nTextID        = 0;
    m_CurrentPercent = 0;
    m_Color          = 0x000000FF;
}

// 2nd constructor
CPercentBar::CPercentBar( UINT nFrameID, UINT nTextID, CWnd *pParent )
{
    m_pParent        = pParent;
    m_nFrameID       = nFrameID;
    m_nTextID        = nTextID;
    m_CurrentPercent = 0;
    m_Color          = 0x000000FF;
    m_Frame.Attach( m_pParent->GetDlgItem( nFrameID )->m_hWnd );
    
    GetSize();
}
    
// destructor
CPercentBar::~CPercentBar()
{
    if( m_pParent != NULL )
        m_Frame.Detach();
}

// subclass the frame
void CPercentBar::SubclassDlgItem( UINT nFrameID, UINT nTextID, CWnd *pParent )
{
    m_pParent  = pParent;
    m_nFrameID = nFrameID;
    m_nTextID  = nTextID;
    m_Frame.Attach( m_pParent->GetDlgItem( nFrameID )->m_hWnd );
    
    GetSize();
}

// set color for the bar
void CPercentBar::SetColor( COLORREF crColor )
{
    m_Color = crColor;
}

// update (redraw) the bar
void CPercentBar::UpdatePercentBar( void )
{
    RECT rTemp;
    
    memcpy( &rTemp, &m_rBorder, sizeof( rTemp ) );
    rTemp.right = GetNewPos( m_CurrentPercent );
    DrawPercentBar( rTemp );
}

// set new percent-value and update it
void CPercentBar::SetPercent( int nPercent )
{
    if( nPercent != m_CurrentPercent )
        {
        RECT rTemp;
        
        memcpy( &rTemp, &m_rBorder, sizeof( rTemp ) );
        if( m_CurrentPercent > 0 )
            m_CurrentPercent--;
        rTemp.left = GetNewPos( m_CurrentPercent );
        rTemp.right = GetNewPos( nPercent );
        m_CurrentPercent = nPercent;
        DrawPercentBar( rTemp );
        }
}    

// get the client-area
void CPercentBar::GetSize( void )
{
    m_Frame.GetClientRect( &m_rBorder );
    m_rBorder.left++;
    m_rBorder.top += 2;
    m_rBorder.right -= 2;
    m_rBorder.bottom--;
    m_fWidth = m_rBorder.right - m_rBorder.left;
}

// get the position of the current percent-value
int CPercentBar::GetNewPos( int iPercent )
{
    return (int)((m_fWidth / 100) * (float)iPercent) + 2;
}

// draw the bar
void CPercentBar::DrawPercentBar( RECT &rDraw )
{
    CDC    *dc = m_Frame.GetDC();
    CBrush myBrush( m_Color );
    CBrush *pOldBrush;
    CPen   myPen( PS_NULL, 0, 0 );
    CPen   *pOldPen;
    char   szString[20];
    
    // select the brush and pen
    pOldBrush = dc->SelectObject( &myBrush );
    pOldPen = dc->SelectObject( &myPen );
    
    // draw it...
    dc->Rectangle( &rDraw );
    
    // select old brush
    dc->SelectObject( pOldBrush );
    dc->SelectObject( pOldPen );
    myBrush.DeleteObject();
    myPen.DeleteObject();
    
    m_Frame.ReleaseDC( dc );
    
    // set the text
    if( m_nTextID != 0 )
        {
        sprintf( szString, "%d %%", m_CurrentPercent );
        m_pParent->SetDlgItemText( m_nTextID, szString );
        }
}
