///////////////////////////////////////////////////////////////////
// class for a "percentbar"

class CPercentBar
{ 
public:
    CPercentBar();
    CPercentBar( UINT nFrameID,             // ID of the frame
                 UINT nTextID,              // ID of the static-text (may be 0)
                 CWnd *pParent );           // the window (dialog) with the frame
    ~CPercentBar();
    
    void SubclassDlgItem( UINT nFrameID,    // ID of the frame
                          UINT nTextID,     // ID of the static-text (may be 0)
                          CWnd *pParent );  // the window (dialog) with the frame
    void SetColor( COLORREF crColor );      // set the color for the bar
    void UpdatePercentBar( void );          // put this call into your "OnPaint" routine
    void SetPercent( int nPercent );        // set new value and redraw bar
    
private:
    CWnd     *m_pParent;        // the parent
    CWnd     m_Frame;           // the frame
    UINT     m_nFrameID;        // ID of frame
    UINT     m_nTextID;         // ID of text
    int      m_CurrentPercent;  // current percent value
    float    m_fWidth;          // width of the frame
    RECT     m_rBorder;         // dimensions of the frame
    COLORREF m_Color;           // color
    
    // get the client-area
    void GetSize( void );
    
    // get new position
    int GetNewPos( int iPercent );

    // draw the bar
    void DrawPercentBar( RECT &rDraw );
};
