//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#ifndef __TOKENS_HPP
#define __TOKENS_HPP
#include "strings.hpp"

//---------------------------------------------------------------------------
// The Tokenizer class breaks a null terminated string into tokens.  A token
// is defined by a group of characters in succession which do not contain any
// of the characters which are defined as delimeters.  The class provides a
// set of default delimeters - i.e., tab, new line, carriage return, and form
// feed, but these can be overridden on construction.  Once the string has
// been broken into tokens, access to those tokens is available to the user
// by index, through an iterator, and via a search.
//
// Because the Tokenizer class is derived from the String class, it is
// possible to change the contents of the data after instantiation.  Since
// this is possible, the actual work of tokenizing the string is provided
// outside of the constructor.  So, if you wanted to use this class to, say,
// parse an input file, where each line needed to be parsed individually,
// (like a parameter file), you would construct a Tokenizer once, then, for
// each line in the file, change the contents of the string to the line read,
// then invoke the tokenize() method.
//---------------------------------------------------------------------------
class Tokenizer : public String
{
        static char *defDelimeters;
    // these first two private members should be handled by another
    // class.  the Array class.
        String **tokens;    // array of Strings is representation
        int NumberTokens;   // number of elements in the array
        String separators;  // separates tokens
        int CurrentSlot;    // used by the iterator

    public:
        Tokenizer();        // default constructor
        Tokenizer(String&, String&); // the real thing
        Tokenizer(char *, char * = defDelimeters);
        Tokenizer(String&, char * = defDelimeters);
        Tokenizer(const Tokenizer&);    // copy constructor
        ~Tokenizer();                   // got to delete that array
        String* operator()();           // iterator
        String* operator[](const int) const;  // by index
        void reset() { CurrentSlot = 0; }
        void tokenize();                // actually does the parsing
        int find(const char *) const;   // find this character string
        int find(const String&) const;  // find this string
                                        // the two finds return 0 if
                                        // not found, index + 1 if found.
};

#endif