//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#include "tokens.hpp"
#include <string.h>
#include <assert.h>

//---------------------------------------------------------------------------
// The Tokenizer class breaks a null terminated string into tokens.  A token
// is defined by a group of characters in succession which do not contain any
// of the characters which are defined as delimeters.  The class provides a
// set of default delimeters - i.e., tab, new line, carriage return, and form
// feed, but these can be overridden on construction.  Once the string has
// been broken into tokens, access to those tokens is available to the user
// by index, through an iterator, and via a search.
//
// Because the Tokenizer class is derived from the String class, it is
// possible to change the contents of the data after instantiation.  Since
// this is possible, the actual work of tokenizing the string is provided
// outside of the constructor.  So, if you wanted to use this class to, say,
// parse an input file, where each line needed to be parsed individually,
// (like a parameter file), you would construct a Tokenizer once, then, for
// each line in the file, change the contents of the string to the line read,
// then invoke the tokenize() method.
//---------------------------------------------------------------------------
char* Tokenizer::defDelimeters = "\t\n\r\f ";

Tokenizer::Tokenizer()        // invokes default constructor for base
{                             // and separators
    tokens = 0;

    // have to zero out CurrentSlot and NumberTokens because the tokenize
    // method is not called here
    CurrentSlot = NumberTokens = 0;
}

Tokenizer::Tokenizer(String& s, String& sep) : String(s), separators(sep)
{
    tokens = 0;
    tokenize();
}

Tokenizer::Tokenizer(String& s, char *sep) : String(s), separators(sep)
{
    tokens = 0;
    tokenize();
}

Tokenizer::Tokenizer(char *s, char *sep) : String(s), separators(sep)
{
    tokens = 0;
    tokenize();
}

Tokenizer::Tokenizer(const Tokenizer& s)
                           : String(s), separators(s.separators)
{
    tokens = 0;
    tokenize();
}

Tokenizer::~Tokenizer()                   // got to delete that array
{
    if (tokens)
    {
        for (int i = 0; i < NumberTokens; ++i)
            delete tokens[i];
        delete [NumberTokens] tokens;
    }
}

void Tokenizer::tokenize()
{
char *tmp, *stmp;

    if (tokens)
    {
        for (int i = 0; i < NumberTokens; ++i)
            delete tokens[i];
        delete [NumberTokens] tokens;
    }

    stmp = (char *)*this;
    CurrentSlot = NumberTokens = 0;
    tmp = strtok(stmp, separators);
    while (tmp)
    {
        ++NumberTokens;
        tmp = strtok(0, separators);
    }
    tokens = new String* [NumberTokens];
    for (int i = 0; i < NumberTokens; ++i)
    {
        tokens[i] = new String(stmp);
        assert(tokens[i]);
        while (*stmp++);
    }
}

int Tokenizer::find(const char *s) const    // returns index + 1, 
                                            // 0 means not found
{
String tmp = (char *)s;

    return find(tmp);
}

int Tokenizer::find(const String& s) const
{
    for (int i = 0; i < NumberTokens; ++i)
    {
        if (*tokens[i] == s)
           return i;
    }
    return 0;
}

String* Tokenizer::operator()()           // iterator
{
    if (CurrentSlot == NumberTokens)
       return 0;

    return tokens[CurrentSlot++];
}

String* Tokenizer::operator[](const int i) const       // by index
{
    if (i >= NumberTokens)
       return 0;

    return tokens[i];
}
