//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#ifndef __STRINGS_HPP
#define __STRINGS_HPP

#include <iostream.h>

//---------------------------------------------------------------------------
// A pretty standard implementation of the String class, except that it is
// not derived from some base "Object".
//---------------------------------------------------------------------------
class String
{
        static const char * const def;

    protected:          // derived classes will need access
        char *data;
        int   len;

    public:
        String();                                // default constructor
        String(char *);
        String(const String&);                   // copy constructor
        ~String();
        int length() const { return len; }
    String mid(int, int);           // start and length
    String left(int);           // left n chars
    String right(int);          // right n chars
        int print(ostream&) const;               // returns # chars output
        int compare(const String&);
        String operator+(const String&) const;   // add strings return result
        String operator+(const char *) const;    // add string and char*
        String operator+(const char c) const;    // add a character
        String& operator+=(const String&);       // tack a string onto one
        String& operator=(const String&);        // assignment operator
        char operator[](const int) const;        // char by index
        operator char *() const { return data; }
friend ostream& operator<<(ostream&, const String&);    // output
friend int operator==(const String&, const String&);    // equality
friend int operator!=(const String&, const String&);    // inequality
friend int operator<(const String&, const String&);     // less than
friend int operator>(const String&, const String&);     // greater than
friend int operator>=(const String&, const String&);
friend int operator<=(const String&, const String&);

};

#endif