//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#include <string.h>
#include <assert.h>
#include <iostream.h>
#include "strings.hpp"

//---------------------------------------------------------------------------
// The String class is very similar to any other string class.  It was my
// first attempt at writing a class, written after hours while taking a class
// on object oriented programming.  One difference in my implementation of
// this class, is that the default constructor for a String makes the data
// pointer equal to a static string whose contents is <null>.  Therefore, an
// empty string is one whose data pointer is equal to the location of that
// static string.
//---------------------------------------------------------------------------
const char *String::def = "<null>";

String::String()
{
    data = (char *)def;
    len = strlen(data);
}

String::String(char *s)
{
    if (s)  // make sure it's not a null pointer
    {
        data = new char[strlen(s) + 1];
        assert(data);             // if not allocated, bomb out
        strcpy(data, s);
    }
    else
        data = (char *)def;
    len = strlen(data);
}

String::String(const String& s)   // copy constructor
{
    len = strlen(s.data);
    data = new char[len + 1];
    assert(data);
    strcpy(data, s.data);
}

String::~String()
{
    if (data != def)
       delete data;
}

String String::mid(int start, int n)
{

    if (start >= len)
    {
        String tmp;
        return tmp;
    }

    char *tc = new char[len - start + 1];
    strncpy(tc, &data[start], n);
    if (n < len - start)
        tc[n] = '\0';
    String tmp(tc);
    return tmp;
}

String String::left(int n)
{
    return mid(0, n);
}

String String::right(int n)
{
    return mid(len - n, n);
}

int String::print(ostream& o) const           // returns # chars output
{
    o << data;
    return len;
}

String String::operator+(const String& s) const    // add strings
{
String tmp;

    if (s.data != def)
    {
        tmp.len = strlen(s.data) + ((data == def) ? 0 : strlen(data));
        tmp.data = new char[len + 1];
        assert(tmp.data);
        if (data != def)
        {
            strcpy(tmp.data, data);
            strcpy(&tmp.data[len], s.data);
        }
        else
            strcpy(tmp.data, s.data);

    }
    return tmp;
}

char String::operator[](const int i) const
{
    if (i < len)
        return data[i];
    else
        return '\0';
}

String String::operator+(const char *s) const
{
String tmp = (char *)s;

       return (*this + tmp);
}

String String::operator+(const char c) const
{
String tmp;

    if (data == def)
    {
        tmp.data = new char[sizeof(char) + 1];
        *tmp.data = c;
        tmp.data[1] = '\0';
        tmp.len = 1;
    }
    else
    {
        tmp.len = len + 1;
        tmp.data = new char[tmp.len + 1];
        strcpy(tmp.data, data);
        tmp.data[tmp.len - 1] = c;
        tmp.data[tmp.len] = '\0';
    }
    return tmp;
}

String& String::operator=(const String& s)     // assignment operator
{
    if (s.data == data)
       return *this;

    if (data != def)
       delete data;

    len = strlen(s.data);
    data = new char[len + 1];
    strcpy(data, s.data);
    return *this;
}

ostream& operator << (ostream& o, const String& s)
{
    o << s.data;
    return o;
}

int String::compare(const String& p)
{
    return strcmp(data, p.data);
}

int operator==(const String& p, const String& q)
{
    if (p.len != q.len)
       return 0;

    return strcmp(p.data, q.data) ? 0 : 1;
}

int operator!=(const String& p, const String& q)
{
    if (p.len != q.len)
       return 1;

    return strcmp(p.data, q.data) ? 1 : 0;
}

int operator < (const String& p, const String& q)
{
    return (strcmp(p.data, q.data) < 0) ? 1 : 0;
}

int operator > (const String& p, const String& q)
{
    return (strcmp(q.data, p.data) < 0) ? 1 : 0;
}

int operator <= (const String& p, const String& q)
{
int diff;

    return ((diff = strcmp(p.data, q.data)) < 0) ? 1 : diff == 0 ? 1 : 0;
}

int operator >= (const String& p, const String& q)
{
int diff;

    return ((diff = strcmp(q.data, p.data)) < 0) ? 1 : diff == 0 ? 1 : 0;
}
