//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#ifndef __MYPDX_HPP
#define __MYPDX_HPP

#include <ui_gen.hpp>
#include <pdxpp.h>
#include "tokens.hpp"
#include "environ.hpp"

//---------------------------------------------------------------------------
// The DataPathTable is an enhancement of the PXTABLE class that I downloaded
// from CompuServe.  This class opens a table if it exists in the current
// directory.  If it doesn't exist in the current directory, it looks in the
// Environment for a string matching PDXDATA.  If found, it uses that path,
// which is a path specified like any other, allowing semi-colons to delimit
// multiple paths, to search for the table.  It will use the first table it
// successfully opens in that path.
//---------------------------------------------------------------------------
class DataPathTable : public PXTABLE
{
    private:
        static Environment env;
        static Tokenizer paths;

    public:
        DataPathTable(char *name, int index = 0, int SaveEveryChange = FALSE);
};

//---------------------------------------------------------------------------
// PublicTableElement is an element in a list maintained by the PublicTable
// class.  It retains the name of a table, the number of "processes" using
// the table, and the table's handle.  When a table is opened for the first
// time, a new PublicTableElement is added to the PublicTable's static list
// of tables.  Subsequent attempts to open the same table do not return an
// error that the table is already open, instead, an instance count is 
// incremented.  This is very important in an event driven application, as
// several dialog boxes, or other "processes" may be running concurrently,
// needing access to the same tables.  There's no reason why they shouldn't
// have concurrent access, unless one has locked the table.  This class 
// implements that type of behavior.
//---------------------------------------------------------------------------
class PublicTableElement : public UI_ELEMENT
{
    friend class PublicTable;

    private:
        String Name;
        int usage;
        TABLEHANDLE handle;
        static int find(void *el1, void *match);
        int locked;             // lock indicator

    public:
        PublicTableElement(char *name, TABLEHANDLE hdl);
};

//---------------------------------------------------------------------------
// PublicTable allows concurrent access to one table by more than one 
// "process".  Very important in a pseudo-multitasking environment such as an
// event driven application (a windowing environment).
//---------------------------------------------------------------------------
class PublicTable : public DataPathTable
{
    private:
        static UI_LIST list;    // a list of PublicTableElements
        PublicTableElement *me; // this table in the list

    public:
        PublicTable(char *name, int index = 0, int SaveEveryChange = FALSE);
        int Lock(void) { return (me->usage > 1) ? 0 : me->locked = TRUE; }
        int Unlock(void) { return me->locked = FALSE; }
        ~PublicTable(void);
};

#endif        