//
// $Header$
// $Log$
//
// COPYRIGHT 1991, Object Systems, Inc.
// Objective Systems, Inc.
// 14 Woodcrest Rd.
// Boonton, NJ  07005
//
// Author:
//  Richard Doust            (201) 335-0691
//  CompuServe               76130,3247
//

#include <string.h>
#include "strings.hpp"
#include "pxtabs.hpp"
#include "environ.hpp"

//---------------------------------------------------------------------------
// Establish the static variables for the classes implemented here
//---------------------------------------------------------------------------
Environment DataPathTable::env;
Tokenizer DataPathTable::paths(env.GetString("PDXDATA"), ";");
UI_LIST PublicTable::list;

//---------------------------------------------------------------------------
// The DataPathTable is an enhancement of the PXTABLE class that I downloaded
// from CompuServe.  This class opens a table if it exists in the current
// directory.  If it doesn't exist in the current directory, it looks in the
// Environment for a string matching PDXDATA.  If found, it uses that path,
// which is a path specified like any other, allowing semi-colons to delimit
// multiple paths, to search for the table.  It will use the first table it
// successfully opens in that path.
//---------------------------------------------------------------------------
DataPathTable::DataPathTable(char *name, int index, int SaveEveryChange)
: PXTABLE(name, index, SaveEveryChange)
{
String *pPath;
char fullPath[128];

    if (pxerr != PXSUCCESS)
    {
        paths.reset();
        for (pPath = paths(); pPath && pxerr != PXSUCCESS; pPath = paths())
        {
            strcpy(fullPath, (char *)(*pPath));
            strcat(fullPath, "\\");
            strcat(fullPath, name);
            pxerr = PXTblOpen(fullPath, &tblHandle, index, SaveEveryChange);
        }
    }
}

//---------------------------------------------------------------------------
// PublicTable allows concurrent access to one table by more than one 
// "process".  Very important in a pseudo-multitasking environment such as an
// event driven application (a windowing environment).
//---------------------------------------------------------------------------
PublicTable::PublicTable(char *name, int index, int SaveEveryChange)
: DataPathTable(name, index, SaveEveryChange)
{
PublicTableElement *found;

    if (pxerr == PXERR_TABLEOPEN)
    {
        if (found = (PublicTableElement *)list.Get(PublicTableElement::find, name))
        {
            if (!found->locked)
            {
                found->usage++;
                me = found;
                tblHandle = found->handle;
                pxerr = 0;
            }
        }
    }
    else if (pxerr == PXSUCCESS)
    {
        me = new PublicTableElement(name, tblHandle);
        list.Add(me);
    }
}

PublicTable::~PublicTable(void)
{
    if (--me->usage)
        tblHandle = 0;
    else
    {
        list.Subtract(me);
        delete me;
    }
}

//---------------------------------------------------------------------------
// PublicTableElement is an element in a list maintained by the PublicTable
// class.  It retains the name of a table, the number of "processes" using
// the table, and the table's handle.  When a table is opened for the first
// time, a new PublicTableElement is added to the PublicTable's static list
// of tables.  Subsequent attempts to open the same table do not return an
// error that the table is already open, instead, an instance count is 
// incremented.  This is very important in an event driven application, as
// several dialog boxes, or other "processes" may be running concurrently,
// needing access to the same tables.  There's no reason why they shouldn't
// have concurrent access, unless one has locked the table.  This class 
// implements that type of behavior.
//---------------------------------------------------------------------------
PublicTableElement::PublicTableElement(char *name, TABLEHANDLE hdl)
: Name(name)
{
    usage = 1;
    handle = hdl;
}

//---------------------------------------------------------------------------
// Find is used to locate an item in the PublicTableElement list.  The
// implementation of UI_LIST::Get() takes a pointer to a comparison function
// which returns a zero on an exact match of the match data, and any other
// value means no match.  This method simply returns the result of a compare
// done on the two Strings.
//---------------------------------------------------------------------------
int PublicTableElement::find(void *el1, void *match)
{
    String look((char *)match);
    return ((PublicTableElement *)el1)->Name.compare(look);
}
    

        