/*----------------------------------------------------------------
            VLIB.C Generated by PARAGen version 2.20          
------------------------------------------------------------------
  PROJECT         : VIDLIB DEMO PROGRAM
  AUTHOR          : Innovative Data Solutions, Inc.
  DATE            : 03/14/1991
  TIME            : 01:49PM
  CODING STYLE    : 2  - [Standard C]
  TAB EXPANSION   : ON
  TABLE           : VLIB.DB - [Fields: 15, Key Fields: 2]
  DATABASE FIELDS          PARADOX                   PARAGEN
                           -------                   -------
                    (01) - Category                  Category                  
                    (02) - Title                     Title                     
                    (03) - Rating                    Rating                    
                    (04) - Director                  Director                  
                    (05) - Stars                     Stars                     
                    (06) - Cast                      Cast                      
                    (07) - Company                   Company                   
                    (08) - Date                      Date                      
                    (09) - Price                     Price                     
                    (10) - Tape                      Tape                      
                    (11) - RunTime                   RunTime                   
                    (12) - Format                    Format                    
                    (13) - Start                     Start                     
                    (14) - Stop                      Stop                      
                    (15) - RunSpeed                  RunSpeed                  
  GENERATED BY    : Innovative Data Solutions, Inc. Paradox Code Generator
                    4318 Stewart Court
                    East Chicago, IN 46312
                    (219)-397-8952
-----------------------------------------------------------------*/

/*----------------------------------------------------------------
                        Global Defines                            
------------------------------------------------------------------
  BUFFERED - is used in the PXTblOpen call to establish whether 
             writes should be buffered or not (SEE engine manual)
             (TRUE)  - save records to disk as they are posted
             (FALSE) - buffer above records for speed purposes
  GLOBAL   - Global define used to declare global variables.  If it
             is defined variables are declared, otherwise they are
             external so you can reference them in another module
-----------------------------------------------------------------*/

#define BUFFERED FALSE
#define GLOBAL 1

/*----------------------------------------------------------------
                           Include Files                          
-----------------------------------------------------------------*/

#include "vlib.h"
#include "pxengine.h"

/*----------------------------------------------------------------
                           Code Starts                            
-----------------------------------------------------------------*/

int VLIBError(int ErrCode)
{
	if (ErrCode)		
		return(ErrCode);
	return(PXSUCCESS);
}

int VLIBTblOpen(char *Password)
{
	if (Password)
		{
		VLIBRet = PXPswAdd(Password);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		}
	VLIBRet = PXTblOpen("VLIB",&VLIBTable,0,BUFFERED);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecBufOpen(VLIBTable,&VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Category",&VLIBCategory);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Title",&VLIBTitle);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Rating",&VLIBRating);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Director",&VLIBDirector);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Stars",&VLIBStars);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Cast",&VLIBCast);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Company",&VLIBCompany);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Date",&VLIBDate);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Price",&VLIBPrice);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Tape",&VLIBTape);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"RunTime",&VLIBRunTime);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Format",&VLIBFormat);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Start",&VLIBStart);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"Stop",&VLIBStop);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXFldHandle(VLIBTable,"RunSpeed",&VLIBRunSpeed);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblClose(void)
{
	VLIBRet = PXTblClose(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblCreate(int TableSize)
{
	static char *VLIBFields[] =
		{
		"Category",
		"Title",
		"Rating",
		"Director",
		"Stars",
		"Cast",
		"Company",
		"Date",
		"Price",
		"Tape",
		"RunTime",
		"Format",
		"Start",
		"Stop",
		"RunSpeed",
		};

	static char *VLIBTypes[] =
		{
		"A10",
		"A40",
		"A5",
		"A15",
		"A55",
		"A30",
		"A15",
		"D",
		"$",
		"S",
		"N",
		"A8",
		"S",
		"S",
		"A10",
		};

	static FIELDHANDLE VLIBFieldHandles[] =
		{
		1,
		2,
		};

	if (!TableSize)
		{
		VLIBRet = PXTblMaxSize(TableSize);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		}
	VLIBRet = PXTblCreate("VLIB",15,VLIBFields,VLIBTypes);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXKeyAdd("VLIB",2,VLIBFieldHandles,PRIMARY);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblEmpty(void)
{
	VLIBRet = PXTblEmpty("VLIB");
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblDelete(void)
{
	VLIBRet = PXTblDelete("VLIB");
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblCopy(char *FileName,int SrcOrDest)
{
	if (SrcOrDest == SOURCE)		
		VLIBRet = PXTblCopy("VLIB",FileName);
	else		
		VLIBRet = PXTblCopy(FileName,"VLIB");
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblRename(char *DestTable)
{
	VLIBRet = PXTblRename("VLIB",DestTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblAdd(char *FileName,int SrcOrDest)
{
	if (SrcOrDest == SOURCE)		
		VLIBRet = PXTblAdd("VLIB",FileName);
	else		
		VLIBRet = PXTblAdd(FileName,"VLIB");
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblEncrypt(char *Password)
{
	VLIBRet = PXTblEncrypt("VLIB",Password);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblDecrypt(char *Password)
{
	VLIBRet = PXPswAdd(Password);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXTblDecrypt("VLIB");
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblExist(int *Exists)
{
	VLIBRet = PXTblExist("VLIB",Exists);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblProtected(int *IsProtected)
{
	VLIBRet = PXTblProtected("VLIB",IsProtected);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBTblNRecs(RECORDNUMBER *NumRecords)
{
	VLIBRet = PXTblNRecs(VLIBTable,NumRecords);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecNum(RECORDNUMBER *NumRecords)
{
	VLIBRet = PXRecNum(VLIBTable,NumRecords);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBSrchKey(int SearchMode,int NumKeysToSearch,VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	switch (NumKeysToSearch)
		{
		case 2:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal->Title);
			if (VLIBRet)				
				if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 					
					return(VLIBRet);
		case 1:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal->Category);
			if (VLIBRet)				
				if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 					
					return(VLIBRet);
		}
	VLIBRet = PXSrchKey(VLIBTable,VLIBRecord,NumKeysToSearch,SearchMode);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBSrchFld(int SearchMode,char *FieldToSearch,VLIBTABLEENTRY *RecordVal)
{
	FIELDHANDLE FldHandle;
	long ParaDate;

	VLIBRet = PXFldHandle(VLIBTable,FieldToSearch,&FldHandle);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	switch (FldHandle)
		{
		case 1:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal->Category);
			break;

		case 2:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal->Title);
			break;

		case 3:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBRating,RecordVal->Rating);
			break;

		case 4:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBDirector,RecordVal->Director);
			break;

		case 5:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBStars,RecordVal->Stars);
			break;

		case 6:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBCast,RecordVal->Cast);
			break;

		case 7:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBCompany,RecordVal->Company);
			break;

		case 8:			
			VLIBRet = PXDateEncode(RecordVal->DateMonth,RecordVal->DateDay,RecordVal->DateYear,&ParaDate);
			if (VLIBRet)				
				if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 					
					return(VLIBRet);
			VLIBRet = PXPutDate(VLIBRecord,VLIBDate,ParaDate);
			break;

		case 9:			
			VLIBRet = PXPutDoub(VLIBRecord,VLIBPrice,RecordVal->Price);
			break;

		case 10:			
			VLIBRet = PXPutShort(VLIBRecord,VLIBTape,RecordVal->Tape);
			break;

		case 11:			
			VLIBRet = PXPutDoub(VLIBRecord,VLIBRunTime,RecordVal->RunTime);
			break;

		case 12:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBFormat,RecordVal->Format);
			break;

		case 13:			
			VLIBRet = PXPutShort(VLIBRecord,VLIBStart,RecordVal->Start);
			break;

		case 14:			
			VLIBRet = PXPutShort(VLIBRecord,VLIBStop,RecordVal->Stop);
			break;

		case 15:			
			VLIBRet = PXPutAlpha(VLIBRecord,VLIBRunSpeed,RecordVal->RunSpeed);
			break;

		}
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXSrchFld(VLIBTable,VLIBRecord,FldHandle,SearchMode);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecFirst(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecFirst(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecNext(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecNext(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecPrev(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecPrev(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecLast(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecLast(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecAppend(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecAppend(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecInsert(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecInsert(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecDelete(void)

{
	VLIBRet = PXRecDelete(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecUpdate(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecUpdate(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecGoto(RECORDNUMBER RecordNumber)
{
	VLIBRet = PXRecGoto(VLIBTable,RecordNumber);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecGet(VLIBTABLEENTRY *RecordVal)
{
	VLIBRet = PXRecBufEmpty(VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	VLIBRet = VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBFldType(FIELDHANDLE fldHandle,char *FldType)
{
	int BufSize = 6;

	VLIBRet = PXFldType(VLIBTable,fldHandle,BufSize,FldType);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBFldBlank(FIELDHANDLE fldHandle,int *IsBlank)
{
	VLIBRet = PXFldBlank(VLIBRecord,fldHandle,IsBlank);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBRecNFlds(int *NumFields)
{
	VLIBRet = PXRecNFlds(VLIBTable,NumFields);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBKeyNFlds(int *NumKeyFields)
{
	VLIBRet = PXKeyNFlds(VLIBTable,NumKeyFields);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetRecLocked(int *IsLocked)
{
	VLIBRet = PXNetRecLocked(VLIBTable,IsLocked);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetTblChanged(int *IsChanged)
{
	VLIBRet = PXNetTblChanged(VLIBTable,IsChanged);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetTblRefresh(void)
{
	VLIBRet = PXNetTblRefresh(VLIBTable);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetTblUnlock(int LockType)
{
	VLIBRet = PXNetTblUnlock(VLIBTable,LockType);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetTblLock(int LockType)
{
	VLIBRet = PXNetTblLock(VLIBTable,LockType);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetRecUnlock(LOCKHANDLE LckHandle)
{
	VLIBRet = PXNetRecUnlock(VLIBTable,LckHandle);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetRecLock(LOCKHANDLE *LckHandle)
{
	VLIBRet = PXNetRecLock(VLIBTable,LckHandle);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetRecGotoLock(LOCKHANDLE LckHandle)
{
	VLIBRet = PXNetRecGotoLock(VLIBTable,LckHandle);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetFileUnlock(int LockType)
{
	VLIBRet = PXNetFileUnlock("VLIB.db",LockType);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBNetFileLock(int LockType)
{
	VLIBRet = PXNetFileLock("VLIB.db",LockType);
	if (VLIBRet)		
		if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 			
			return(VLIBRet);
	return(PXSUCCESS);
}

int VLIBPopulateRecord(VLIBTABLEENTRY *RecordVal,int GetOrPut)
{
	long ParaDate;

	if (GetOrPut)
		{
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal->Category);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal->Title);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBRating,RecordVal->Rating);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBDirector,RecordVal->Director);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBStars,RecordVal->Stars);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBCast,RecordVal->Cast);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBCompany,RecordVal->Company);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXDateEncode(RecordVal->DateMonth,RecordVal->DateDay,RecordVal->DateYear,&ParaDate);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutDate(VLIBRecord,VLIBDate,ParaDate);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutDoub(VLIBRecord,VLIBPrice,RecordVal->Price);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutShort(VLIBRecord,VLIBTape,RecordVal->Tape);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutDoub(VLIBRecord,VLIBRunTime,RecordVal->RunTime);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBFormat,RecordVal->Format);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutShort(VLIBRecord,VLIBStart,RecordVal->Start);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutShort(VLIBRecord,VLIBStop,RecordVal->Stop);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXPutAlpha(VLIBRecord,VLIBRunSpeed,RecordVal->RunSpeed);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		}
	else
		{
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBCategory,FSZCATEGORY+1,RecordVal->Category);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBTitle,FSZTITLE+1,RecordVal->Title);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBRating,FSZRATING+1,RecordVal->Rating);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBDirector,FSZDIRECTOR+1,RecordVal->Director);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBStars,FSZSTARS+1,RecordVal->Stars);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBCast,FSZCAST+1,RecordVal->Cast);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBCompany,FSZCOMPANY+1,RecordVal->Company);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetDate(VLIBRecord,VLIBDate,&ParaDate);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXDateDecode(ParaDate,&RecordVal->DateMonth,&RecordVal->DateDay,&RecordVal->DateYear);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetDoub(VLIBRecord,VLIBPrice,&RecordVal->Price);
		if (ISBLANKDOUBLE(RecordVal->Price))			
			RecordVal->Price = 0.0;
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetShort(VLIBRecord,VLIBTape,&RecordVal->Tape);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetDoub(VLIBRecord,VLIBRunTime,&RecordVal->RunTime);
		if (ISBLANKDOUBLE(RecordVal->RunTime))			
			RecordVal->RunTime = 0.0;
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBFormat,FSZFORMAT+1,RecordVal->Format);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetShort(VLIBRecord,VLIBStart,&RecordVal->Start);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetShort(VLIBRecord,VLIBStop,&RecordVal->Stop);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		VLIBRet = PXGetAlpha(VLIBRecord,VLIBRunSpeed,FSZRUNSPEED+1,RecordVal->RunSpeed);
		if (VLIBRet)			
			if ((VLIBRet = VLIBError(VLIBRet)) != PXSUCCESS) 				
				return(VLIBRet);
		}
	return(PXSUCCESS);
}

