UNIT VIDUTIL;

INTERFACE

USES
	Dos,Crt;

Const
	VIDEO_IO : Byte = $10;
	CUR_POS  : Byte = 2;
	SCROLL_UP: Byte = 6;

(*----------------------------------------------------------------
                       Function Prototypes                        
-----------------------------------------------------------------*)

PROCEDURE GoToRC(Row,Col:Byte);
PROCEDURE ClearArea(Row,Col,NumRows,NumCols:Byte);
PROCEDURE CenterText(Row,Col,Cols:Byte;Title:String);
PROCEDURE DrawBox(Row,Col,NumRows,NumCols:Byte;Title:String);
PROCEDURE PrintText(Row,Col:Byte;Title:String);
FUNCTION Strupr(SValue:String):String;
FUNCTION GetString(Row,Col,Width:Byte;Var SValue:String;UpperCase:Boolean):String;
PROCEDURE CLearMessageArea;

IMPLEMENTATION

(*----------------------------------------------------------------
                          Function Implementation                  
-----------------------------------------------------------------*)

PROCEDURE GoToRC(Row,Col:Byte);
Var
	InRegs:Registers;
Begin
	InRegs.ah := CUR_POS;
	InRegs.bh := 0;
	InRegs.dh := (Row-1) and $FF;
	InRegs.dl := (Col-1) and $FF;
	Intr(VIDEO_IO,InRegs);
End;


PROCEDURE ClearArea(Row,Col,NumRows,NumCols:Byte);

Var InRegs:Registers;

Begin
	InRegs.ah := SCROLL_UP;
	InRegs.al := 0;
	InRegs.bh := 7;
	InRegs.bl := 0;
	InRegs.ch := Row-1;
	InRegs.cl := Col-1;
	InRegs.dh := NumRows+1;
	InRegs.dl := NumCols+1;
	Intr(VIDEO_IO,InRegs);
End;

PROCEDURE CenterText(Row,Col,Cols:Byte;Title:String);

Begin

	GoToRC(Row,((Cols-(Length(Title))) div 2)+Col);
	write(Title);
End;


PROCEDURE DrawBox(Row,Col,NumRows,NumCols:Byte;Title:String);

Const
	BoxType : String[6] = 'ɻͺȼ';

Var
	Loop,Loop1:Byte;

Begin
	GoToRC(Row,Col);
	Write(BoxType[1]);
	for Loop := 0 to NumCols-3 do
		Write(BoxType[3]);
	Write(BoxType[2]);

	for Loop := 1 to NumRows-2 do
		Begin
			GoToRC(Loop+Row,Col);
			Write(BoxType[4]);
			for Loop1 := 0 to NumCols-3 do
				Write(' ');
			Write(BoxType[4]);
		End;

	GoToRC(NumRows+Row-1,Col);
	Write(BoxType[5]);
	for Loop := 0 to NumCols-3 do
		Write(BoxType[3]);
	Write(BoxType[6]);
	CenterText(Row,Col,NumCols,Title);
End;

PROCEDURE PrintText(Row,Col:Byte;Title:String);

Begin
	GoToRC(Row,Col);
	Write(Title);
End;

FUNCTION Strupr(SValue:String):String;
Var
	TStr : String;
	Index,SLength : Byte;
Begin
	SLength := Length(SValue);
	Tstr := Copy(SValue,1,SLength);
	for Index := 1 to Slength do
		TStr[Index] := UpCase(TStr[Index]);
	StrUpr := TStr;
End;

FUNCTION GetString(Row,Col,Width:Byte;Var SValue:String;UpperCase:Boolean):String;
Var
	Key   : Char;
	Index : Byte;
	TempString : String;
	Done,FullWidth : Boolean;
Begin
	FillChar(TempString,sizeof(TempString),#0);
	TempString[0] := #0;
	TempString := Copy(SValue,1,Length(SValue));
	GoToRC(Row,Col);

	Done := FALSE;
	FullWidth := FALSE;
	Index := 1;
	While (not Done) do
		Begin
			Key := ReadKey;
			if (Key = #27) then
				Begin
					TempString[0] := #0;
					if (UpperCase) then
						GetString := Strupr(SValue)
					else
						GetString := SValue;
					Done := TRUE;
				End;
			if (Key = #13) or (Key = #10) then
				Begin
					FullWidth := TRUE;
					Done := TRUE;
					if (Index = 1) then
						Index := Length(TempString)+1;
				End
			else
				Begin
					if (UpperCase) then
						Write(Upcase(Key))
					else
						Write(Key);
					TempString[Index] := Key;
					Index := Index+1;
					if (Index <= Width) then
						Done := FALSE
					else
						Begin
							FullWidth := TRUE;
							Done := TRUE;
						End;
				End;
		End;

	if (FullWidth) then
		Begin
			TempString[0] := chr(Index-1);
			if (UpperCase) then
				SValue := Copy(Strupr(TempString),1,Length(TempString))
			else
				SValue := Copy(TempString,1,Length(TempString));
			GetString := SValue;
		End
End;

PROCEDURE ClearMessageArea;

Var
	Spaces : String;
Begin
	FillChar(SPaces,sizeof(String),' ');
	Spaces[0] := #70;
	PrintText(23,5,Spaces);
	PrintText(24,5,Spaces);
End;

End.



