# ------------------------------------------------------------------------
#  		      PARAGEN.EXE 
# ------------------------------------------------------------------------
# Written 3/3/91 MGM for DOS version of VIDLIB.  Uses Borland C++ compiler
# Uses new TURBO make facility 3.0,4.0
# Turbo C 2.0 users will have to add PXENGTC2.LIb to the link line below
# (line 128)	
#
# SYNTAX: Just type MAKE -fVIDLIB.MAK (it must be Turbo 3.0 or 4.0 make.exe)
#	  The makefile must be named VIDLIB.MAK
#
# This make file creates a sub-dir based on the MODEL
# defined below.  All of the OBJ's will end up in this
# directory.  The executable will get built in the
# current directory.  This was done to keep memory
# model specific code in one directory and to keep
# those same OBJ's from cluttering the source directory.
# When you run this make file make sure the file
# MAKEDIR.COM is present somewhere in your path.  This is
# a replacement for the DOS mkdir command.  Since mkdir 
# returned an error if the directory already existed, I wrote
# my own.  You can replace makedir with md in the DIR macro
# below.
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
#  		     	     PRODUCTION OPTIONS 
# ------------------------------------------------------------------------
#
#  -G -- Generate code for speed
#  -Z -- Optimize register usage
#  -w -- Invoke highest warning check
#  -N -- Check stack overflow
#  -c -- Compile the code only
#  -O -- Optimize jumps
#  -d -- Merge duplcate strings
#  -j -- Stop after 10 errors
#  -g -- Stop after 10 warnings
#
#  /c -- Tells linker case is significant in symbols
#
# ------------------------------------------------------------------------

#COPTS=-G -Z -w -N -c -O	-d -j10 -g10
#EXEOPTS=/c

# ------------------------------------------------------------------------
#  		    	     DEBUGGING OPTIONS 
# ------------------------------------------------------------------------
#  -G -- Generate code for speed
#  -Z -- Optimize register usage
#  -w -- Invoke highest warning check
#  -N -- Check stack overflow
#  -c -- Compile the code only
#  -O -- Optimize jumps
#  -d -- Merge duplcate strings
#  -j -- Stop after 10 errors
#  -g -- Stop after 10 warnings
#  -v -- Source level debugging 
#  -y -- Produce line number info
#
#  /c -- Tells linker case is significant in symbols
#  /v -- Tells linker to include full symbolic info
#  /l -- Tells linker to include source line numbers
# ------------------------------------------------------------------------

COPTS=-G -Z -w -N -c -O -d -j10 -g10 
EXEOPTS=/c /v

# ------------------------------------------------------------------------
# 	 	Paradox ENGINE and TURBO C++ information 
# ------------------------------------------------------------------------
#
# INCLUDE -- All include directories the application needs (including TC)
# LIBS    -- All library directories the appliaction needs (except TC)
# TCLIB   -- Turbo-C library directory
#
# NOTE:	 If no model is specified the default is LARGE
#
# ------------------------------------------------------------------------

INCLUDE=g:\bcc\include;l:\paradox3\eng20\c
LIBS=l:\paradox3\eng20\c
TCLIB=g:\bcc\lib
!if !$d(MODEL)
MODEL=l
!endif

# ------------------------------------------------------------------------
# 	    	      NEW MAKE 3.0 extended features
# ------------------------------------------------------------------------
#
#  SWAP - Turns EMS swapping on
#  PATH.obj - Where to find the OBJS (sub-dir named by MODEL)
#  PATH.lib - Where to find the libraries for linking

.SWAP
.PATH.obj=$(MODEL)
.PATH.lib=$(LIBS)

# ------------------------------------------------------------------------
#        	Implicit rule for the compiler option
# ------------------------------------------------------------------------

.c.obj :
	bcc -I$(INCLUDE) -n$(MODEL) -m$(MODEL) $(COPTS) {$< }

# ------------------------------------------------------------------------
#        		How we build the Executable
# ------------------------------------------------------------------------
#
#  Declare a bogus target, then declare three dependencies
#  (1) To create the directory using replacement MKDIR (makedir.com)
#  (2) To build the actual EXE
#  {3) This makefile is always a dependency
#
# ------------------------------------------------------------------------

fred : DIR vidlib.exe vidlib.mak

vidlib.exe : vidutil.obj vidlib.obj vlib.obj
	tlink $(EXEOPTS) -lP @&&!
$(TCLIB)\c0$(MODEL)+
$(MODEL)\vidlib+
$(MODEL)\vlib+
$(MODEL)\vidutil,+
vidlib,NUL, $(LIBS)\pxengtc$(MODEL) $(TCLIB)\emu $(TCLIB)\math$(MODEL) $(TCLIB)\c$(MODEL)
!


# ------------------------------------------------------------------------
#        		Dependencies for the C files
# ------------------------------------------------------------------------

vidlib.obj:	vidlib.h vlib.h

vidutil.obj:	vidlib.h vlib.h

vlib.obj:	vlib.h


# ------------------------------------------------------------------------
#      		Create seperate Directory based on MODEL
# ------------------------------------------------------------------------
#
#  Can also use DOS md command but an error message will
#  show up on the screen.  This does not stop processing.
#
# ------------------------------------------------------------------------

DIR :
	makedir $(MODEL)


