#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <ctype.h>
#include "vlib.h"
#include "vidlib.h"

void GoToRC(unsigned Row, unsigned Col) {

	union REGS InRegs,OutRegs;

	InRegs.h.ah = CUR_POS;
	InRegs.h.bh = 0;
	InRegs.h.dh = (Row-1) & 0xFF;
	InRegs.h.dl = (Col-1) & 0xFF;

	int86(VIDEO_IO,&InRegs,&OutRegs);

}


void ClearArea(unsigned Row,unsigned Col,unsigned NumRows,unsigned NumCols) {

	union REGS InRegs,OutRegs;

	InRegs.h.ah = SCROLL_UP;
	InRegs.h.al = 0;
	InRegs.h.bh = 7;
	InRegs.h.bl = 0;
	InRegs.h.ch = Row-1;
	InRegs.h.cl = Col-1;
	InRegs.h.dh = NumRows+1;
	InRegs.h.dl = NumCols+1;
	int86(VIDEO_IO,&InRegs,&OutRegs);

	
}


void DrawBox(unsigned Row,unsigned Col,unsigned NumRows,unsigned NumCols,char *Title) {
	
	unsigned Loop,Loop1;
	static unsigned char BoxType[] = "ɻͺȼ";



	GoToRC(Row,Col);
	printf("%c",BoxType[0]);
	for (Loop = 0; Loop < NumCols-2; Loop++)
		printf("%c",BoxType[2]);
	printf("%c",BoxType[1]);

	for (Loop = 1; Loop < NumRows -1; Loop++) {
		GoToRC(Loop+Row,Col);
		printf("%c",BoxType[3]);
		for (Loop1 = 0; Loop1 < NumCols-2; Loop1++)
			printf(" ");
		printf("%c",BoxType[3]);
	}

	GoToRC(NumRows+Row-1,Col);
	printf("%c",BoxType[4]);
	for (Loop = 0; Loop < NumCols-2; Loop++)
		printf("%c",BoxType[2]);
	printf("%c",BoxType[5]);
	CenterText(Row,Col,NumCols,Title);


}

void PrintText(unsigned Row,unsigned Col,char *Title) {

	GoToRC(Row,Col);
	printf("%s",Title);
	
}

void CenterText(unsigned Row,unsigned Col, unsigned Cols,char *Title) {

	GoToRC(Row,(Cols-(strlen(Title)))/2+Col);
	printf("%s",Title);
	
}

char *GetString(unsigned Row,unsigned Col,unsigned Width,char *SValue,BOOLEAN UpperCase) {

	unsigned Index;
	int Key;
	static char TempString[80];

	memset(TempString,'\0',sizeof(TempString));
	strcpy(TempString,SValue);

	GoToRC(Row,Col);
	for (Index=0; Index < Width; Index++) {
		Key = getch();
		if (Key == 27) {
			TempString[Index] = '\0';
			if (UpperCase)
				return(strupr(SValue));
			else
				return(SValue);
		}
		if (Key == 13 || Key == 10) {
			if (Index != 0)
				TempString[Index] = '\0';
			if (UpperCase)
				strcpy(SValue,strupr(TempString));
			else
				strcpy(SValue,TempString);
			return(SValue);
		}
		else {
			if (UpperCase)
				printf("%c",toupper(Key));
			else 
				printf("%c",Key);
			TempString[Index] = Key;
		}
	}
	TempString[Index] = '\0';
	if (UpperCase)
		strcpy(SValue,strupr(TempString));
	else
		strcpy(SValue,TempString);
	return(SValue);
}



void PrintFText(BOOLEAN GetChar,unsigned Row,unsigned Col, char *PrintFormat, ...) {

   char *ConvertedString;
   char ConvertBuffer[80];
   va_list Argp;
	int Index;

   memset(ConvertBuffer,'\0',sizeof(ConvertBuffer));
  	ConvertedString = ConvertBuffer;
   va_start(Argp,PrintFormat);
	vsprintf(ConvertedString,PrintFormat,Argp);
   va_end(Argp);

	GoToRC(Row,Col);
	printf("%s",ConvertedString);
	if (GetChar) {
		getch();
		GoToRC(Row,Col);
		for (Index = 0; Index < strlen(ConvertedString); Index++)
			printf(" ");
	}

}

void ClearMessageArea(void) {

	char Spaces[80];
	

	memset(Spaces,'\0',sizeof(Spaces));
	memset(Spaces,' ',NUMSPACES);

	PrintText(23,5,Spaces);
	PrintText(24,5,Spaces);
}
