#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "vlib.h"
#include "vidlib.h"

int NumKeys=0;
int FieldNum=0;
BOOLEAN GotSrchKFirst = FALSE;
BOOLEAN GotSrchFFirst = FALSE;

static VLIBTABLEENTRY SearchRecord;

void main(void);
int OpeningScreen(void);
void DisplayFields(void);

void main(void) {

	char Choice[4];

	if (OpeningScreen()) {
		do	{
			GetString(18,68,2,Choice,YES);
			ClearMessageArea();
		} while (ValidEvent(Choice));
		if ((VLIBRet = PXExit()) != PXSUCCESS)
			VLIBError1(VLIBRet);
	}
	ClearArea(1,1,25,80);
}


int OpeningScreen(void) {

	ClearArea(1,1,25,80);

	CenterText(1,1,80,"PARAGen-Video Library Demo..[C Ver 1.4]");
	CenterText(2,1,80,"(C) 90, 91 Innovative Data Solutions, Inc.");
	DrawBox(3,1,13,80,"Video Data");
	DrawBox(12,4,8,74,"Options");
	DrawBox(20,1,3,80,"Paradox Information");
	DrawBox(22,4,4,74,"Error and Input Information");
	DisplayFields();
	if ((VLIBRet = PXInit()) != PXSUCCESS) {
		VLIBError1(VLIBRet);
		return(0);
	}
	return(1);

}

void DisplayFields(void) {

	PrintText(4,3, "1-Title...:");
	PrintText(4,62,"2-Rating..:");
	PrintText(5,3, "3-Star(s).:");
	PrintText(6,3, "4-Cast....:");
	PrintText(6,48,"5-Director:");
	PrintText(7,3, "6-Company.:");
	PrintText(7,33,"7-Category:");
	PrintText(7,59,"8-Date.:");
	PrintText(9,3, "9-Price:$");
	PrintText(9,23,"10-Tape #:");
	PrintText(9,40,"11-Run Time:");
	PrintText(9,60,"12-Format:");
	PrintText(10,3,"13-Start:");
	PrintText(10,23,"14-Stop.:");
	PrintText(10,40,"15-Rec Speed:");

	PrintText(13,5, "AR-Add Record");
	PrintText(14,5, "CT-Close Table");
	PrintText(15,5, "DT-Decrypt Table");
	PrintText(16,5, "DR-Delete Record");
	PrintText(17,5, "ET-Delete Table");
	PrintText(18,5, "ER-Edit Record");

	PrintText(13,23,"FR-First Record");
	PrintText(14,23,"GR-Goto Record");
	PrintText(15,23,"KF-Srch Key 1st");
	PrintText(16,23,"KN-Srch Key Next");
	PrintText(17,23,"LR-Last Record");
	PrintText(18,23,"MT-Merge Table");

	PrintText(13,41,"NT-Encrypt Table");
	PrintText(14,41,"NR-Next Record");
	PrintText(15,41,"OT-Open Table");
	PrintText(16,41,"PT-Copy Table");
	PrintText(17,41,"PR-Prev Record");
	PrintText(18,41,"QU-Quit");

	PrintText(13,59,"RT-Rename Table");
	PrintText(14,59,"SF-Srch Field 1st");
	PrintText(15,59,"SN-Srch Field Next");
	PrintText(16,59,"TT-Create Table");
	PrintText(17,59,"YT-Empty Table");

	PrintText(18,58, "[Choice:      ]");

	PrintText(21,2,"File: None");
	PrintText(21,20,"Records: 0");
	PrintText(21,35,"Fields: 0");
	PrintText(21,49,"Key Fields: 0");
	PrintText(21,66,"Rec No: 0");
	
}

int ValidEvent(char *Choice) {

	int Index,Ret=1,Process=0;

	static PROCESS EventArray[] = {
		{"AR","Record Add Successful",AddRecord},
		{"CT","Table Close Successful",CloseFile},
		{"DT","Table Decrypt Successful",DecryptFile},
		{"DR","Record Delete Successful",DeleteRecord},
		{"ET","Table Delete Successful",DeleteFile},
		{"ER","Record Update Successful",EditRecord},
		{"FR","First Record Successful",FirstRecord},
		{"GR","Goto Record Successful",GotoRecord},
		{"KF","Search Key 1st Successful",SearchKFirst},
		{"KN","Search Key Next Successful",SearchKNext},
		{"LR","Last Record Successful",LastRecord},
		{"MT","Table Merge Successful",MergeFile},
		{"NT","Table Encrypt Successful",EncryptFile},
		{"NR","Next Record Successful",NextRecord},
		{"OT","Table Open Successful",OpenFile},
		{"PT","Table Copy Successful",CopyFile},
		{"PR","Prev Record Successful",PreviousRecord},
		{"RT","Table Rename Successful",RenameFile},
		{"SF","Search Field 1st Successful",SearchFFirst},
		{"SN","Search Field Next Successful",SearchFNext},
		{"TT","Table Create Successful",CreateFile},
		{"YT","Table Empty Successful",EmptyFile}
	};

	if (strncmp(Choice,"QU",2) == 0)
		return(0);

	for (Index = 0; Index < 23; Index++)
		if (strncmp(Choice,EventArray[Index].Item,2) == 0) {
			Process=1;
			break;
		}

	if (Process) {
		Ret = (EventArray[Index].Execute)();
		if (!Ret)
			PrintText(24,6,EventArray[Index].Message);
		else
			VLIBError1(Ret);
	}
	else 
		PrintFText(YES,24,6,"%s is an invalid option - Hit any Key",Choice);
	return(1);

}



int AddRecord(void) {

	VLIBTABLEENTRY RecordEntry;

	if (EditRec(&RecordEntry,NO)) {
		if ((VLIBRet = VLIBRecInsert(&RecordEntry)) == PXSUCCESS) {
			DisplayRecord(&RecordEntry);
			UpdateParadoxInfo(YES);
		}
	}
	return(VLIBRet);
}
int CloseFile(void) {

	UpdateParadoxInfo(NO);
	ClearRecord();
	return(VLIBTblClose());
}

int SearchFFirst(void) {

	VLIBTABLEENTRY RecordEntry;

	GotSrchFFirst = FALSE;
	memset((VLIBTABLEENTRY *)&SearchRecord,'\0',sizeof(VLIBTABLEENTRY));
	VLIBRet = -1;
	if (SrchRec(&SearchRecord,NO)) {
		ClearMessageArea();
		if ((VLIBRet = VLIBRecGet(&RecordEntry)) == PXSUCCESS) {
			DisplayRecord(&RecordEntry);
			UpdateParadoxInfo(YES);
			GotSrchFFirst = TRUE;
		}
	}

	return(VLIBRet);
}

int SearchFNext(void) {

	VLIBTABLEENTRY RecordEntry;

	VLIBRet = -1;
	if (GotSrchFFirst) {
		if (SrchRec(&SearchRecord,NO)) {
			ClearMessageArea();
			if ((VLIBRet = VLIBRecGet(&RecordEntry)) == PXSUCCESS) {
				DisplayRecord(&RecordEntry);
				UpdateParadoxInfo(YES);
				GotSrchFFirst = TRUE;
			}
		}
	}
	else
		PrintText(24,6,"No search field is set up, call Srch Field 1st");
	return(VLIBRet);
}
int SearchKFirst(void) {

	VLIBTABLEENTRY RecordEntry;

	memset((VLIBTABLEENTRY *)&SearchRecord,'\0',sizeof(VLIBTABLEENTRY));
	GotSrchKFirst = FALSE;
	VLIBRet = -1;
	if (SrchRec(&SearchRecord,YES)) {
		ClearMessageArea();
		if ((VLIBRet = VLIBSrchKey(SEARCHFIRST,NumKeys,&SearchRecord)) == PXSUCCESS)	{
			if ((VLIBRet = VLIBRecGet(&RecordEntry)) == PXSUCCESS) {
				DisplayRecord(&RecordEntry);
				UpdateParadoxInfo(YES);
				GotSrchKFirst = TRUE;
			}
		}
	}
	return(VLIBRet);
}
int SearchKNext(void) {

	VLIBTABLEENTRY RecordEntry;

	VLIBRet = -1;
	if (GotSrchKFirst) {
		if ((VLIBRet = VLIBSrchKey(SEARCHNEXT,NumKeys,&SearchRecord)) == PXSUCCESS)	{
			if (VLIBRecGet(&RecordEntry) == PXSUCCESS) {
				DisplayRecord(&RecordEntry);
				UpdateParadoxInfo(YES);
			}
		}
	}
	else
		PrintText(24,6,"No search key is set up, call Srch Key 1st");

	return(VLIBRet);
}
int DecryptFile(void) {

	char Choice[16];
	int IsProtected;

	if ((VLIBRet = VLIBTblProtected(&IsProtected)) == PXSUCCESS) {
		if (IsProtected) {
			PrintFText(NO,24,6,"Enter Password:");
			GetString(24,23,15,Choice,NO);
			ClearMessageArea();
			return(VLIBTblDecrypt(Choice));
		}
		else {
			VLIBRet = -1;
			PrintText(24,6,"Table is not encrypted");
		}
	}
	return(VLIBRet);
}

int DeleteRecord(void) {

	char Choice[3]; 
	VLIBTABLEENTRY RecordEntry;

 	PrintFText(NO,24,6,"Delete Current Record (Y or N):");
	GetString(24,38,1,Choice,YES);
	ClearMessageArea();
	VLIBRet = -1;
	if (Choice[0] == 'Y')
		if ((VLIBRet = VLIBRecDelete()) == PXSUCCESS) {
			if ((VLIBRet = VLIBRecGet(&RecordEntry)) == PXSUCCESS) {
				DisplayRecord(&RecordEntry);
				UpdateParadoxInfo(YES);
			}
			else {
				if (VLIBRet == PXERR_TABLEEMPTY) {
					ClearRecord();
					UpdateParadoxInfo(YES);
				}
			}
		}
	return(VLIBRet);

}

int DeleteFile(void) {
	
	UpdateParadoxInfo(NO);
	ClearRecord();
	return(VLIBTblDelete());
}

int EditRecord(void) {

	VLIBTABLEENTRY RecordEntry;
	VLIBRet = -1;
	if (EditRec(&RecordEntry,YES)) {
		if ((VLIBRet = VLIBRecUpdate(&RecordEntry)) == PXSUCCESS) {
			DisplayRecord(&RecordEntry);
		}
	}
	return(VLIBRet);
}

int FirstRecord(void) {

	VLIBTABLEENTRY RecordEntry;

	if ((VLIBRet = VLIBRecFirst(&RecordEntry)) == PXSUCCESS) {
		DisplayRecord(&RecordEntry);
		UpdateParadoxInfo(YES);
	}
	return(VLIBRet);
}
int GotoRecord(void) {

	char Choice[8];
	VLIBTABLEENTRY RecordEntry;
	RECORDNUMBER Value;

	PrintFText(NO,24,6,"Goto record No:");
	GetString(24,22,6,Choice,NO);
	Value = atol(Choice);
	ClearMessageArea();
	if ((VLIBRet = VLIBRecGoto(Value)) == PXSUCCESS) {
		if ((VLIBRet = VLIBRecGet(&RecordEntry)) == PXSUCCESS) {
			DisplayRecord(&RecordEntry);
			UpdateParadoxInfo(YES);
		}
	}
	return(VLIBRet);
}
int LastRecord(void) {

	VLIBTABLEENTRY RecordEntry;

	if ((VLIBRet = VLIBRecLast(&RecordEntry)) == PXSUCCESS) {
		DisplayRecord(&RecordEntry);
		UpdateParadoxInfo(YES);
	}
	return(VLIBRet);
}
int MergeFile(void) {

	char Choice[9];

	PrintFText(NO,24,6,"File to merge into %s.db (No Extension):",VLIBName);
	GetString(24,49,8,Choice,YES);
	ClearMessageArea();
	return(VLIBTblAdd(Choice,DESTINATION));

}

int EncryptFile(void) {

	char Choice[16];

	PrintFText(NO,24,6,"Enter Password:");
	GetString(24,23,15,Choice,NO);
	ClearMessageArea();
	return(VLIBTblEncrypt(Choice));
}

int NextRecord(void) {

	VLIBTABLEENTRY RecordEntry;

	if ((VLIBRet = VLIBRecNext(&RecordEntry)) == PXSUCCESS) {
		DisplayRecord(&RecordEntry);
		UpdateParadoxInfo(YES);
	}
	return(VLIBRet);
}
int OpenFile(void) {
	char Choice[16];
	char *Value = NULL;
	int IsProtected;

	if ((VLIBRet = VLIBTblProtected(&IsProtected)) == PXSUCCESS) {
		if (IsProtected) {
			PrintFText(NO,24,6,"Enter Password:");
			GetString(24,23,15,Choice,NO);
			ClearMessageArea();
			Value = Choice;
		}
	}
	else
		return(VLIBRet);
	if ((VLIBRet = VLIBTblOpen(Value)) == PXSUCCESS)
		return(FirstRecord());
	return(VLIBRet);
}
int PreviousRecord(void) {

	VLIBTABLEENTRY RecordEntry;

	if ((VLIBRet = VLIBRecPrev(&RecordEntry)) == PXSUCCESS) {
		DisplayRecord(&RecordEntry);
		UpdateParadoxInfo(YES);
	}
	return(VLIBRet);
}

int Quit(void) {
	return(1);
}

int RenameFile(void) {

	char Choice[9];
	
	PrintFText(NO,24,6,"Rename %s.DB to (No extension):",VLIBName);
	GetString(24,40,8,Choice,YES);
	ClearMessageArea();
	return(VLIBTblRename(Choice));
}
int CreateFile(void) {

	char Choice[3];

	VLIBRet = -1;
	PrintFText(NO,24,6,"Over Write %s.DB (Y or N):",VLIBName);
	GetString(24,35,1,Choice,YES);
	ClearMessageArea();
	if (Choice[0] == 'Y')
		return(VLIBTblCreate(64));
	return(VLIBRet);
}
int EmptyFile(void) {

	ClearRecord();
	return(VLIBTblEmpty());
}
int CopyFile(void) {

	char Choice[9];
	
	PrintFText(NO,24,6,"File to copy from (No extension):");
	GetString(24,40,8,Choice,YES);
	ClearMessageArea();
	return(VLIBTblCopy(Choice,DESTINATION));
}

void UpdateParadoxInfo(BOOLEAN UseInfo) {

	static int PRow = 21;
	static int PCol[] = {8,29,43,61,74};
	RECORDNUMBER NumRecs=0,CurrRec=0;
	int NumFields=0;
	int NKeys=0;
	char TableName[13];

	strcpy(TableName,"None");
	if (UseInfo) {
		strcpy(TableName,VLIBName);
		strcat(TableName,".DB");
		VLIBTblNRecs(&NumRecs);
		VLIBRecNFlds(&NumFields);
		VLIBKeyNFlds(&NKeys);
		VLIBRecNum(&CurrRec);
	}

	PrintText(PRow,PCol[0],"            ");
	PrintText(PRow,PCol[1],"    ");
	PrintText(PRow,PCol[2],"    ");
	PrintText(PRow,PCol[3],"    ");
	PrintText(PRow,PCol[4],"    ");

	PrintFText(NO,PRow,PCol[0],"%s",TableName);
	PrintFText(NO,PRow,PCol[1],"%ld",NumRecs);
	PrintFText(NO,PRow,PCol[2],"%d",NumFields);
	PrintFText(NO,PRow,PCol[3],"%d",NKeys);
	PrintFText(NO,PRow,PCol[4],"%ld",CurrRec);

}

void DisplayRecord(VLIBTABLEENTRY *RecordEntry) {

	static DRow[] = {4,4,5,6,6,7,7,7,9,9,9,9,10,10,10};
	static DCol[] = {15,74,15,15,60,15,45,68,15,32,53,70,14,33,53};

	ClearRecord();
	PrintFText(NO,DRow[0],DCol[0],"%s",RecordEntry->Title);
	PrintFText(NO,DRow[1],DCol[1],"%s",RecordEntry->Rating);
	PrintFText(NO,DRow[2],DCol[2],"%s",RecordEntry->Stars);
	PrintFText(NO,DRow[3],DCol[3],"%s",RecordEntry->Cast);
	PrintFText(NO,DRow[4],DCol[4],"%s",RecordEntry->Director);
	PrintFText(NO,DRow[5],DCol[5],"%s",RecordEntry->Company);
	PrintFText(NO,DRow[6],DCol[6],"%s",RecordEntry->Category);
	PrintFText(NO,DRow[7],DCol[7],"%02d/%02d/%d",RecordEntry->DateMonth,RecordEntry->DateDay,RecordEntry->DateYear);
	PrintFText(NO,DRow[8],DCol[8],"%3.2f",RecordEntry->Price);
	PrintFText(NO,DRow[9],DCol[9],"%d",RecordEntry->Tape);
	PrintFText(NO,DRow[10],DCol[10],"%2.2f",RecordEntry->RunTime);
	PrintFText(NO,DRow[11],DCol[11],"%s",RecordEntry->Format);
	PrintFText(NO,DRow[12],DCol[12],"%d",RecordEntry->Start);
	PrintFText(NO,DRow[13],DCol[13],"%d",RecordEntry->Stop);
	PrintFText(NO,DRow[14],DCol[14],"%s",RecordEntry->RunSpeed);

}

void ClearRecord(void) {

	static CRow[] = {4,4,5,6,6,7,7,7,9,9,9,9,10,10,10};
	static CCol[] = {15,74,15,15,60,15,45,68,15,32,53,70,14,33,53};
	static Len[] = {40,5,55,30,15,15,10,10,7,5,7,8,7,7,10};
	int Index;
	char Spaces[80];
	

	memset(Spaces,'\0',sizeof(Spaces));
	memset(Spaces,' ',sizeof(Spaces)-1);

	for (Index =0; Index < 15; Index++)
		PrintFText(NO,CRow[Index],CCol[Index],"%*.*s",Len[Index],Len[Index],Spaces);
}

int EditRec(VLIBTABLEENTRY *RecordEntry,BOOLEAN EditOnly) {

	char Choice[80];

	static ERow[] = {4,4,5,6,6,7,7,7,9,9,9,9,10,10,10};
	static ECol[] = {15,74,15,15,60,15,45,68,15,32,53,70,14,33,53};
	static ELen[] = {40,5,55,30,15,15,10,10,7,5,7,8,7,7,10};

	memset(RecordEntry,'\0',sizeof(VLIBTABLEENTRY));

	if (EditOnly) {
		if (VLIBRecGet(RecordEntry) != PXSUCCESS)
			return(0); 
	}
	else
	  ClearRecord();

	GetString(ERow[0],ECol[0],ELen[0],RecordEntry->Title,NO);
	GetString(ERow[1],ECol[1],ELen[1],RecordEntry->Rating,NO);
	GetString(ERow[2],ECol[2],ELen[2],RecordEntry->Stars,NO);
	GetString(ERow[3],ECol[3],ELen[3],RecordEntry->Cast,NO);
	GetString(ERow[4],ECol[4],ELen[4],RecordEntry->Director,NO);
	GetString(ERow[5],ECol[5],ELen[5],RecordEntry->Company,NO);
	GetString(ERow[6],ECol[6],ELen[6],RecordEntry->Category,NO);
	if (!EditOnly)
		PrintText(ERow[7],ECol[7],"  /  /");

	if (EditOnly) {
		sprintf(Choice,"%d",RecordEntry->DateMonth);
		GetString(ERow[7],ECol[7],2,Choice,NO);
		RecordEntry->DateMonth = atoi(Choice); 
		sprintf(Choice,"%d",RecordEntry->DateDay);
		GetString(ERow[7],ECol[7]+3,2,Choice,NO);
		RecordEntry->DateDay = atoi(Choice);
		sprintf(Choice,"%d",RecordEntry->DateYear);
		GetString(ERow[7],ECol[7]+6,4,Choice,NO);
		RecordEntry->DateYear = atoi(Choice);

		sprintf(Choice,"%3.2f",RecordEntry->Price);
		GetString(ERow[8],ECol[8],ELen[8],Choice,NO);
		RecordEntry->Price = atof(Choice);

		sprintf(Choice,"%d",RecordEntry->Tape);
		GetString(ERow[9],ECol[9],ELen[9],Choice,NO);
		RecordEntry->Tape = atoi(Choice);

		sprintf(Choice,"%3.2f",RecordEntry->RunTime);
		GetString(ERow[10],ECol[10],ELen[10],Choice,NO);
		RecordEntry->RunTime = atof(Choice);

	}
	else {
		GetString(ERow[7],ECol[7],2,Choice,NO);
		RecordEntry->DateMonth = atoi(Choice); 
		GetString(ERow[7],ECol[7]+3,2,Choice,NO);
		RecordEntry->DateDay = atoi(Choice);
		GetString(ERow[7],ECol[7]+6,2,Choice,NO);
		RecordEntry->DateYear = atoi(Choice);
		GetString(ERow[8],ECol[8],ELen[8],Choice,NO);
		RecordEntry->Price = atof(Choice);
		GetString(ERow[9],ECol[9],ELen[9],Choice,NO);
		RecordEntry->Tape = atoi(Choice);
		GetString(ERow[10],ECol[10],ELen[10],Choice,NO);
		RecordEntry->RunTime = atof(Choice);

	}

	GetString(ERow[11],ECol[11],ELen[11],RecordEntry->Format,NO);

	if (EditOnly) {
  		sprintf(Choice,"%d",RecordEntry->Start);
		GetString(ERow[12],ECol[12],ELen[12],Choice,NO);
		RecordEntry->Start = atoi(Choice);
		sprintf(Choice,"%d",RecordEntry->Stop);
		GetString(ERow[13],ECol[13],ELen[13],Choice,NO);
		RecordEntry->Stop = atoi(Choice);
	}
	else {
		GetString(ERow[12],ECol[12],ELen[12],Choice,NO);
		RecordEntry->Start = atoi(Choice);
		GetString(ERow[13],ECol[13],ELen[13],Choice,NO);
		RecordEntry->Stop = atoi(Choice);
	}

	GetString(ERow[14],ECol[14],ELen[14],RecordEntry->RunSpeed,NO);
	return(1);
	
}


int SrchRec(VLIBTABLEENTRY *RecordEntry,BOOLEAN KeyOrFld) {

	static SRow[] = {4,4,5,6,6,7,7,7,9,9,9,9,10,10,10};
	static SCol[] = {15,74,15,15,60,15,45,68,15,32,53,70,14,33,53};
	static SLen[] = {40,5,55,30,15,15,10,10,7,5,7,8,7,7,10};
	static char *FieldArray[] = {
										"Title",
										"Rating",
										"Stars",
										"Cast",
										"Director",
										"Company",
										"Category",
										"Date",
										"Price",
										"Tape",
										"RunTime",
										"Format",
										"Start",
										"Stop",
										"RunSpeed"
								  		 };
	int Field,NumFields,NKeys;
	int Mode=SEARCHFIRST,Ret=1;

	char Choice[80];
	
	ClearRecord();

	if (VLIBRecNFlds(&NumFields) != PXSUCCESS)
		return(0);
	if (VLIBKeyNFlds(&NKeys) != PXSUCCESS)
		return(0);
	if (KeyOrFld) {	/* only key fields */
	
		PrintFText(NO,24,6,"Number of keys to search on (1 or %d):",NKeys);
		GetString(24,44,1,Choice,YES);
		ClearMessageArea();
		Field = atoi(Choice);
		if (Field < 1 || Field > NKeys) {
			PrintFText(YES,24,6,"Invalid number of keys - Hit any Key");
			return(0);
		}
		NumKeys=Field;
		switch (Field) {
			case 2:
				GetString(SRow[0],SCol[0],SLen[0],RecordEntry->Title,NO);
			case 1:
				GetString(SRow[6],SCol[6],SLen[6],RecordEntry->Category,NO);
			break;
		}
	}
	else {
		if (!GotSrchFFirst) {
			PrintFText(NO,24,6,"Field to search on (1 - %d):",NumFields);
			GetString(24,34,2,Choice,YES);
			ClearMessageArea();
			Field = atoi(Choice);
			if (Field < 1 || Field > NumFields) {
				PrintFText(YES,24,6,"%d Invalid Field Number  - Hit any Key",Field);
				return(0);
			}
			FieldNum=Field;
		}
		else {
			Mode = SEARCHNEXT;
			Field = FieldNum;
		}
		switch(Field) {
			case 1:
				if (!GotSrchFFirst)
					GetString(SRow[0],SCol[0],SLen[0],RecordEntry->Title,NO);
			break;
			case 2:
				if (!GotSrchFFirst)
					GetString(SRow[1],SCol[1],SLen[1],RecordEntry->Rating,NO);
			break;
			case 3:
				if (!GotSrchFFirst)
					GetString(SRow[2],SCol[2],SLen[2],RecordEntry->Stars,NO);
			break;
			case 4:
				if (!GotSrchFFirst)
					GetString(SRow[3],SCol[3],SLen[3],RecordEntry->Cast,NO);
			break;
			case 5:
				if (!GotSrchFFirst)
					GetString(SRow[4],SCol[4],SLen[4],RecordEntry->Director,NO);
			break;
			case 6:
				if (!GotSrchFFirst)
					GetString(SRow[5],SCol[5],SLen[5],RecordEntry->Company,NO);
			break;
			case 7:
				if (!GotSrchFFirst)
					GetString(SRow[6],SCol[6],SLen[6],RecordEntry->Category,NO);
			break;
			case 8:
				if (!GotSrchFFirst) {
					GetString(SRow[7],SCol[7],2,Choice,NO);
					RecordEntry->DateMonth = atoi(Choice); 
					GetString(SRow[7],SCol[7]+3,2,Choice,NO);
					RecordEntry->DateDay = atoi(Choice);
					GetString(SRow[7],SCol[7]+6,2,Choice,NO);
					RecordEntry->DateYear = atoi(Choice);
				}
			break;
			case 9:
				if (!GotSrchFFirst) {
					GetString(SRow[8],SCol[8],SLen[8],Choice,NO);
					RecordEntry->Price = atof(Choice);
				}
			break;
			case 10:
				if (!GotSrchFFirst) {
					GetString(SRow[9],SCol[9],SLen[9],Choice,NO);
					RecordEntry->Tape = atoi(Choice);
				}
			break;
			case 11:
				if (!GotSrchFFirst) {
					GetString(SRow[10],SCol[10],SLen[10],Choice,NO);
					RecordEntry->RunTime = atof(Choice);
				}
			break;
			case 12:
				if (!GotSrchFFirst)
					GetString(SRow[11],SCol[11],SLen[11],RecordEntry->Format,NO);
			break;
			case 13:
				if (!GotSrchFFirst) {
					GetString(SRow[12],SCol[12],SLen[12],Choice,NO);
					RecordEntry->Start = atoi(Choice);
				}
			break;
			case 14:
				if (!GotSrchFFirst) {
					GetString(SRow[13],SCol[13],SLen[13],Choice,NO);
					RecordEntry->Stop = atoi(Choice);
				}
			break;
			case 15:
				if (!GotSrchFFirst)
					GetString(SRow[14],SCol[14],SLen[14],RecordEntry->RunSpeed,NO);
			break;
			
		}
		if (VLIBSrchFld(Mode,FieldArray[Field-1],RecordEntry) != PXSUCCESS)
			Ret=0;
	}
	return(Ret);	
	
}

int VLIBError1(int ErrCode) {

	if (ErrCode > 0) {
		PrintFText(YES,24,6,"[Err :%d] %s (Hit any Key)",ErrCode,PXErrMsg(ErrCode));
		return(ErrCode);
	}
	return(PXSUCCESS);
}

