/* Copyright (c) 1992, 1993 Dave Boynton */
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <string.h>
#include <conio.h>
#include <errno.h>

#include "vidlib.h"
#include "pcxlib.h"
#define    ESC       27

static char banner[]="PCXLIB v%s Showpcx Copyright (c) 1992, 1993 Dave Boynton\n";

/*///////////////////////////////////////////////////////////////////////////
//            m a i n                                                      //
///////////////////////////////////////////////////////////////////////////*/
int main(int argc, char *argv[])
{
   int  mode=0, depth=0;
   char flag;
   int  rc;

   /*********************************/
   /*   Initialization              */
   /*********************************/
   /* check for command line flags */
   while ( (argc > 1) && ( (*argv[1] == '/') || (*argv[1] == '-') ) ) {
      flag= *(argv[1]+1);
      switch (flag) {
	 case 'd':
	 case 'D':
		if ( *(argv[1]+2) == ' ') {
		   argc--;
		   argv++;
		   depth=atoi(argv[1]);
		} else
		   depth=atoi(argv[1]+2);
		break;
	 case 'm':
	 case 'M':
		if ( *(argv[1]+2) == ' ') {
		   argc--;
		   argv++;
		   mode=atoi(argv[1]);
		} else
		   mode=atoi(argv[1]+2);
		break;
	 case 'h':
	 case 'H': /* force highest mode */
		mode=-1;
		break;
	 default:
		printf("unknown flag '%s'\n", argv[1]);
		break;
      }
      argc--;
      argv++;
   }

   /* Sanity check */
   if ( argc < 2 ) {
      printf("%s\nYou must specify a filename to show.\n",argv[0]);
      printf("Usage: showpcx [ -h ] filename.pcx [filename.pcx ...]\n\n"
	     "    -h will force the highest available resolution to be used.\n"
	     "    -d[6|8] will set 6 or 8 bits per color\n"
	     "    -m[number] will set a specific video mode\n"
	     "Once the file is displayed, use ESC to quit and clear the\n"
	     "screen, or any key to continue.For large files, \n"
	     "use the arrows, PGUP, PGDN, Home, and End keys to move.\n");
      return 1;
   }

   if ( !isVGA() ) {
      fprintf(stderr,"This test program is for VGAs and VESAs only.\n");
      return 1;
   }
   while ( argc > 1 ) {
      Vinit();
      rc=flashPCX(argv[1], mode, depth, 1);
      if ( rc != 'R' )
	Vclose();
      if ( (rc == ESC) || (rc == 'R') )
	break;

      argc--;
      argv++;
   }
   if ( rc ) printf(banner, PCXLIB_VERSION);

   return 0;
}
