/*  showpal.c */

#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "vidlib.h"
#include "pcxlib.h"

PCXF *pf1;
void palette_check(void);
char s[100];
char name[80];

int main(int argc, char *argv[])
{
    int i,c,rc;

    sprintf(s,"PCXLIB v%s Showpal Copyright (c) 1992,1993 Dave Boynton\n", PCXLIB_VERSION);

    if (argc < 2) {
       puts(s);
       printf("You must specify an input .pcx file.\n");
       return 1;
    }
    while ( argc > 1 ) {
        strncpy(name,argv[1],79); name[79]='0';

        /* Open pcx file */
        pf1=fopenPCXr(name); /* also reads header */
        if (pf1->type != PCX256colors ) {
                printf("%s: Wrong pcx file, expected a 256 color file."
                        "(hit any key)\n",name);
                rc=getch();
        } else {
                Vinit();

                /* VGAmode(0x13, pf1->palette); */
                VGAmode(0x13, NULL);
                PCXrealizepalette(pf1,6);
                palette_check();
                Vgotoxy(0,0);
                name[40]='0'; /* no more than 40 characters in a mode 0x13 line */
                putstty(name,0x1f);
                rc=getch();

                Vclose();
                fclosePCX(pf1);
        }
        if ( rc == 0x27 )
                break;
        else {
                argc--;
                argv++;
        }
    }
    printf(s);
    return 0;
}

void palette_check(void)
{
   int i,j,c;
   Vfill256(0,0,320,200,0); /* clear screen */
   for (i=c=0; i<16; i++) {
       for (j=0; j<16; j++) {
           Vfill256(j*20,i*11+21,19,10,c);
           c++;
       }
   }
}

